/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.portmap;

import com.emc.ecs.nfsclient.network.NetMgr;
import com.emc.ecs.nfsclient.portmap.GetPortRequest;
import com.emc.ecs.nfsclient.portmap.GetPortResponse;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.RpcStatus;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;

public class Portmapper {
    private static final int PMAP_PORT = 111;
    private static final int PORTMAP_MAX_REQUEST_SIZE = 128;
    private static int PORTMAP_RPC_TIMEOUT = 10;
    private static int _maxRetry = 2;
    private static boolean _usePrivilegedPort = false;

    public static int queryPortFromPortMap(int program, int version, String serverIP) throws IOException {
        GetPortResponse response = null;
        GetPortRequest request = new GetPortRequest(program, version);
        for (int i = 0; i < _maxRetry; ++i) {
            try {
                Xdr portmapXdr = new Xdr(128);
                request.marshalling(portmapXdr);
                Xdr reply = NetMgr.getInstance().sendAndWait(serverIP, 111, _usePrivilegedPort, portmapXdr, PORTMAP_RPC_TIMEOUT);
                response = new GetPortResponse();
                response.unmarshalling(reply);
                continue;
            }
            catch (RpcException e) {
                Portmapper.handleRpcException(e, i, serverIP);
            }
        }
        int port = response.getPort();
        if (port == 0) {
            String msg = String.format("No registry entry for program: %s, version: %s, serverIP: %s", program, version, serverIP);
            throw new IOException(msg);
        }
        return port;
    }

    private static void handleRpcException(RpcException e, int attemptNumber, String server) throws IOException {
        String messageStart;
        if (!e.getStatus().equals(RpcStatus.NETWORK_ERROR)) {
            messageStart = "network";
        } else {
            if (attemptNumber + 1 < _maxRetry) {
                return;
            }
            messageStart = "rpc";
        }
        throw new IOException(String.format("%s error, server: %s, RPC error: %s", messageStart, server, e.getMessage()), e);
    }

    private Portmapper() {
        throw new NotImplementedException("No class instances should be needed.");
    }
}

