/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.rpc;

import com.emc.ecs.nfsclient.rpc.AcceptStatus;
import com.emc.ecs.nfsclient.rpc.RejectStatus;
import com.emc.ecs.nfsclient.rpc.ReplyStatus;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.Xdr;

public class RpcResponse {
    static final int NOT_ACCEPTED = -1;
    static final int NOT_REJECTED = -1;
    protected int _xid;
    private int _direction;
    private int _replyStatus;
    private int _acceptStatus = -1;
    private int _rejectStatus = -1;

    public void unmarshalling(Xdr xdr) throws RpcException {
        xdr.setOffset(0);
        this._xid = xdr.getInt();
        this._direction = xdr.getInt();
        this._replyStatus = xdr.getInt();
        if (this._replyStatus == ReplyStatus.MSG_ACCEPTED.getValue()) {
            xdr.skip(4);
            xdr.getByteArray();
            this._acceptStatus = xdr.getInt();
        } else {
            this._rejectStatus = xdr.getInt();
        }
        this.checkRpcReply();
    }

    private void checkRpcReply() throws RpcException {
        if (this._replyStatus != ReplyStatus.MSG_ACCEPTED.getValue()) {
            String msg = String.format("RPC call is REJECTED, rejectStat=%d", this._rejectStatus);
            throw new RpcException(RejectStatus.fromValue(this._rejectStatus), msg);
        }
        if (this._acceptStatus != AcceptStatus.SUCCESS.getValue()) {
            String msg = String.format("RPC call is ACCEPTED, but the status is not success, acceptStat=%d", this._acceptStatus);
            throw new RpcException(AcceptStatus.fromValue(this._acceptStatus), msg);
        }
    }

    public int getXid() {
        return this._xid;
    }

    public int getDirection() {
        return this._direction;
    }

    public int getReplyStatus() {
        return this._replyStatus;
    }

    public int getAcceptStatus() {
        return this._acceptStatus;
    }

    public int getRejectStatus() {
        return this._rejectStatus;
    }
}

