/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.rpc;

import com.emc.ecs.nfsclient.network.NetMgr;
import com.emc.ecs.nfsclient.nfs.NfsException;
import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.nfs.NfsResponseBase;
import com.emc.ecs.nfsclient.nfs.NfsStatus;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.RpcRequest;
import com.emc.ecs.nfsclient.rpc.RpcResponseHandler;
import com.emc.ecs.nfsclient.rpc.RpcStatus;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcWrapper<S extends NfsRequestBase, T extends NfsResponseBase> {
    private static final Logger LOG = LoggerFactory.getLogger(RpcWrapper.class);
    private final String _server;
    private int _port;
    private final int _retryWait;
    private final int _maximumRetries;
    private final int _maximumRequestSize;
    private final int _rpcTimeout;
    private String[] _ips;

    public RpcWrapper(String server, int port, int retryWait, int maximumRetries, int maximumRequestSize, int rpcTimeout) {
        this._server = server;
        this._port = port;
        this._retryWait = retryWait;
        this._maximumRetries = maximumRetries;
        this._maximumRequestSize = maximumRequestSize;
        this._rpcTimeout = rpcTimeout;
    }

    public void setPort(int port) {
        this._port = port;
        this._ips = this.probeIps();
    }

    public void callRpcWrapped(S request, RpcResponseHandler<? extends T> responseHandler) throws IOException {
        for (int i = 0; i < this._maximumRetries; ++i) {
            try {
                this.callRpcChecked(request, responseHandler);
                return;
            }
            catch (RpcException e) {
                this.handleRpcException(e, i);
                continue;
            }
        }
    }

    public void callRpcWrapped(S request, RpcResponseHandler<? extends T> responseHandler, String ip) throws IOException {
        for (int i = 0; i < this._maximumRetries; ++i) {
            try {
                this.callRpcChecked(request, responseHandler, ip);
                return;
            }
            catch (RpcException e) {
                this.handleRpcException(e, i);
                continue;
            }
        }
    }

    public void callRpcChecked(S request, RpcResponseHandler<? extends T> responseHandler) throws IOException {
        this.callRpcChecked(request, responseHandler, this.chooseIP(((NfsRequestBase)request).getIpKey()));
    }

    public void callRpcNaked(S request, T response) throws IOException {
        this.callRpcNaked(request, response, this.chooseIP(((NfsRequestBase)request).getIpKey()));
    }

    public void callRpcNaked(S request, T response, String ipAddress) throws RpcException {
        Xdr xdr = new Xdr(this._maximumRequestSize);
        ((NfsRequestBase)request).marshalling(xdr);
        ((NfsResponseBase)response).unmarshalling(this.callRpc(ipAddress, xdr, ((RpcRequest)request).isUsePrivilegedPort()));
    }

    public Xdr callRpc(String serverIP, Xdr xdrRequest, boolean usePrivilegedPort) throws RpcException {
        return NetMgr.getInstance().sendAndWait(serverIP, this._port, usePrivilegedPort, xdrRequest, this._rpcTimeout);
    }

    public String chooseIP(byte[] key) throws IOException {
        if (this._ips == null || this._ips.length == 0) {
            if (this._server != null) {
                LOG.warn("ip list is not initialized, fallback to server");
                return this._server;
            }
            throw new IOException("ip list is not initialized");
        }
        return this._ips[Math.abs(Arrays.hashCode(key)) % this._ips.length];
    }

    private void callRpcChecked(S request, RpcResponseHandler<? extends T> responseHandler, String ipAddress) throws IOException {
        LOG.debug("server {}, port {}, request {}", new Object[]{this._server, this._port, request});
        this.callRpcNaked(request, (NfsResponseBase)responseHandler.getNewResponse(), ipAddress);
        if (LOG.isDebugEnabled()) {
            LOG.debug("server {}, port {}, response {}", new Object[]{this._server, this._port, responseHandler.getResponse()});
        }
        responseHandler.checkResponse((RpcRequest)request);
    }

    private void handleRpcException(RpcException e, int attemptNumber) throws IOException {
        String messageStart;
        if (!e.getStatus().equals(RpcStatus.NETWORK_ERROR)) {
            messageStart = "rpc";
        } else {
            if (attemptNumber + 1 < this._maximumRetries) {
                try {
                    int waitTime = this._retryWait * (attemptNumber + 1);
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                LOG.warn("network error happens, server {}, attemptNumber {}", new Object[]{this._server, attemptNumber});
                return;
            }
            messageStart = "network";
        }
        throw new NfsException(NfsStatus.NFS3ERR_IO, String.format("%s error, server: %s, RPC error: %s", messageStart, this._server, e.getMessage()), e);
    }

    private String[] probeIps() {
        TreeSet<String> ips = new TreeSet<String>();
        for (int i = 0; i < 32; ++i) {
            InetSocketAddress sa = new InetSocketAddress(this._server, this._port);
            ips.add(sa.getAddress().getHostAddress());
        }
        if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (String ip : ips) {
                sb.append(ip);
                sb.append(" ");
            }
            LOG.debug(sb.toString());
        }
        return ips.toArray(new String[0]);
    }
}

