/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.deflate;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.compression.CompressionMetadata;
import com.emc.codec.compression.CompressionUtil;
import com.emc.codec.compression.deflate.DeflateInputStream;
import com.emc.codec.compression.deflate.DeflateOutputStream;
import com.emc.codec.util.CodecUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;

public class DeflateCodec
extends AbstractCodec<CompressionMetadata> {
    public static final String SUBSPEC = "Deflate";
    public static final int PRIORITY = 100;

    public static String encodeSpec(int compressionLevel) {
        return CompressionUtil.getEncodeSpec(SUBSPEC, compressionLevel);
    }

    @Override
    public boolean canProcess(String encodeSpec) {
        String algorithm = CodecUtil.getEncodeAlgorithm(encodeSpec);
        return "COMP".equals(CodecUtil.getEncodeType(encodeSpec)) && algorithm != null && algorithm.startsWith(SUBSPEC);
    }

    @Override
    public String getDefaultEncodeSpec() {
        return DeflateCodec.encodeSpec(5);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public CompressionMetadata createEncodeMetadata(String encodeSpec, Map<String, String> metaMap) {
        return new CompressionMetadata(encodeSpec, metaMap);
    }

    @Override
    public long getDecodedSize(CompressionMetadata metadata) {
        return metadata.getOriginalSize();
    }

    @Override
    public OutputStream getDecodingStream(OutputStream originalStream, CompressionMetadata encodeInfo, Map<String, Object> codecProperties) {
        return new InflaterOutputStream(originalStream);
    }

    @Override
    public InputStream getDecodingStream(InputStream originalStream, CompressionMetadata encodeInfo, Map<String, Object> codecProperties) {
        return new InflaterInputStream(originalStream);
    }

    @Override
    public boolean isSizePredictable() {
        return false;
    }

    @Override
    public long getEncodedSize(long originalSize, String encodeSpec, Map<String, Object> codecProperties) {
        throw new UnsupportedOperationException("compressed size is unpredictable");
    }

    @Override
    public EncodeOutputStream<CompressionMetadata> getEncodingStream(OutputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        if (!this.canEncode(encodeSpec)) {
            throw new IllegalArgumentException("cannot process " + encodeSpec);
        }
        int compressionLevel = CompressionUtil.getCompressionLevel(encodeSpec, 5);
        return new DeflateOutputStream(originalStream, encodeSpec, compressionLevel);
    }

    @Override
    public EncodeInputStream<CompressionMetadata> getEncodingStream(InputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        if (!this.canEncode(encodeSpec)) {
            throw new IllegalArgumentException("cannot process " + encodeSpec);
        }
        int compressionLevel = CompressionUtil.getCompressionLevel(encodeSpec, 5);
        return new DeflateInputStream(originalStream, encodeSpec, compressionLevel);
    }
}

