/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

import com.emc.codec.compression.lzma.LzmaProfile;
import com.emc.object.shadow.SevenZip.Compression.LZMA.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncoderThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(EncoderThread.class);
    public static final ThreadGroup THREAD_GROUP = new ThreadGroup("LZMA-Compress");
    private Encoder encoder;
    private InputStream input;
    private OutputStream output;
    private boolean errorSet = false;
    private Throwable error;

    public EncoderThread(LzmaProfile profile, InputStream input, OutputStream output) throws IOException {
        super(THREAD_GROUP, (Runnable)null);
        this.setDaemon(true);
        this.input = input;
        this.output = output;
        this.encoder = new Encoder();
        this.encoder.SetDictionarySize(profile.dictionarySize);
        this.encoder.SetNumFastBytes(profile.fastBytes);
        this.encoder.SetMatchFinder(profile.matchFinder);
        this.encoder.SetLcLpPb(profile.lc, profile.lp, profile.pb);
        this.encoder.SetEndMarkerMode(true);
        this.encoder.WriteCoderProperties(output);
    }

    @Override
    public void run() {
        try {
            this.encoder.Code(this.input, this.output, -1L, -1L, null);
        }
        catch (Throwable t) {
            log.error("error during compression", t);
            this.error = t;
            this.errorSet = true;
        }
        finally {
            try {
                if (this.input instanceof PipedInputStream) {
                    this.input.close();
                }
            }
            catch (Throwable t) {
                log.warn("could not close input stream", t);
            }
            try {
                if (this.output instanceof PipedOutputStream) {
                    this.output.close();
                }
            }
            catch (Throwable t) {
                log.warn("could not close output stream", t);
            }
        }
    }

    public boolean isErrorSet() {
        return this.errorSet;
    }

    public Throwable getError() {
        return this.error;
    }
}

