/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.encryption;

import com.emc.codec.encryption.EncryptionUtil;
import com.emc.codec.encryption.KeyProvider;
import java.security.KeyPair;
import java.security.Provider;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicKeyProvider
implements KeyProvider {
    private static final Logger log = LoggerFactory.getLogger(BasicKeyProvider.class);
    private KeyPair masterKey;
    private String masterKeyFingerprint;
    private Map<String, KeyPair> keyMap = new HashMap<String, KeyPair>();
    private Provider provider;

    public BasicKeyProvider() {
    }

    public BasicKeyProvider(KeyPair masterKey, KeyPair ... decryptionKeys) {
        this.setMasterKey(masterKey);
        for (KeyPair keyPair : decryptionKeys) {
            this.addKey(keyPair);
        }
    }

    protected String getFingerprint(KeyPair keyPair) {
        return EncryptionUtil.getRsaPublicKeyFingerprint((RSAPublicKey)keyPair.getPublic());
    }

    private void checkKey(KeyPair keyPair) {
        if (!(keyPair.getPublic() instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("Only RSA KeyPairs are allowed, not " + keyPair.getPublic().getAlgorithm());
        }
    }

    private void checkKeyLength(KeyPair keyPair) {
        int keySize = ((RSAPublicKey)keyPair.getPublic()).getModulus().bitLength();
        if (keySize < 1024) {
            throw new IllegalArgumentException("The minimum RSA key size supported is 1024 bits. Your key is " + keySize + " bits");
        }
        if (keySize == 1024) {
            log.warn("1024-bit RSA key detected. Support for 1024-bit RSA keys may soon be removed from the JDK. Please upgrade to a stronger key (e.g. 2048-bit).");
        }
    }

    @Override
    public KeyPair getMasterKey() {
        return this.masterKey;
    }

    public void setMasterKey(KeyPair masterKey) {
        this.checkKey(masterKey);
        this.checkKeyLength(masterKey);
        this.masterKey = masterKey;
        this.masterKeyFingerprint = this.getFingerprint(masterKey);
        this.addKey(masterKey);
    }

    @Override
    public String getMasterKeyFingerprint() {
        return this.masterKeyFingerprint;
    }

    @Override
    public KeyPair getKey(String keyFingerprint) {
        return this.keyMap.get(keyFingerprint);
    }

    public void addKey(KeyPair keyPair) {
        this.checkKey(keyPair);
        this.keyMap.put(this.getFingerprint(keyPair), keyPair);
    }

    public void removeKey(KeyPair keyPair) {
        this.keyMap.remove(this.getFingerprint(keyPair));
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public BasicKeyProvider withMasterKey(KeyPair masterKey) {
        this.setMasterKey(masterKey);
        return this;
    }

    public BasicKeyProvider withKeys(KeyPair ... keys) {
        this.keyMap.clear();
        for (KeyPair key : keys) {
            this.addKey(key);
        }
        return this;
    }

    public BasicKeyProvider withProvider(Provider provider) {
        this.setProvider(provider);
        return this;
    }
}

