/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.encryption;

import com.emc.codec.encryption.BasicKeyProvider;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreKeyProvider
extends BasicKeyProvider {
    private static final Logger log = LoggerFactory.getLogger(KeystoreKeyProvider.class);
    private KeyStore keyStore;
    private char[] keyStorePass;

    public KeystoreKeyProvider(KeyStore keyStore, char[] keyStorePass, String masterKeyAlias) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException {
        this.keyStore = keyStore;
        this.keyStorePass = keyStorePass;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                this.addKey(this.getKeyFromAlias(alias));
            }
            catch (GeneralSecurityException e) {
                log.warn("cannot retrieve key " + alias, (Throwable)e);
            }
        }
        this.setMasterKeyAlias(masterKeyAlias);
    }

    public void setMasterKeyAlias(String masterKeyAlias) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException {
        KeyPair masterKey = this.getKeyFromAlias(masterKeyAlias);
        if (masterKey == null) {
            throw new InvalidKeyException("No certificate found in keystore for alias " + masterKeyAlias);
        }
        this.setMasterKey(masterKey);
    }

    public KeyPair getKeyFromAlias(String alias) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableKeyException {
        if (!this.keyStore.containsAlias(alias)) {
            return null;
        }
        Certificate keyCert = this.keyStore.getCertificate(alias);
        if (keyCert == null) {
            throw new InvalidKeyException("Certificate for alias " + alias + " not found");
        }
        PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, this.keyStorePass);
        if (privateKey == null) {
            throw new InvalidKeyException("Private key for alias " + alias + " not found");
        }
        return new KeyPair(keyCert.getPublicKey(), privateKey);
    }
}

