/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.util;

import java.util.Map;

public final class CodecUtil {
    public static String getEncodeType(String encodeSpec) {
        if (encodeSpec.contains(":")) {
            return encodeSpec.substring(0, encodeSpec.indexOf(":"));
        }
        return encodeSpec;
    }

    public static String getEncodeAlgorithm(String encodeSpec) {
        String algorithm;
        if (encodeSpec.contains(":") && (algorithm = encodeSpec.substring(encodeSpec.indexOf(":") + 1)).trim().length() > 0) {
            return algorithm;
        }
        return null;
    }

    public static String getEncodeSpec(String type, String algorithm) {
        if (algorithm == null || algorithm.trim().length() == 0) {
            return type;
        }
        return type + ":" + algorithm;
    }

    public static <T> T getCodecProperty(String propertyName, Map<String, Object> codecProperties, T defaultValue) {
        if (codecProperties != null && codecProperties.containsKey(propertyName)) {
            return (T)codecProperties.get(propertyName);
        }
        String systemValue = System.getProperty(propertyName);
        if (systemValue != null) {
            if (defaultValue.getClass() == String.class) {
                return (T)systemValue;
            }
            if (defaultValue.getClass() == Integer.class) {
                return (T)Integer.valueOf(systemValue);
            }
            if (defaultValue.getClass() == Long.class) {
                return (T)Long.valueOf(systemValue);
            }
            if (defaultValue.getClass() == Float.class) {
                return (T)Float.valueOf(systemValue);
            }
            if (defaultValue.getClass() == Double.class) {
                return (T)Double.valueOf(systemValue);
            }
        }
        return defaultValue;
    }

    private CodecUtil() {
    }
}

