/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.Range;
import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.util.ProgressInputStream;
import com.emc.object.util.ProgressListener;
import com.emc.object.util.ProgressOutputStream;
import com.emc.rest.util.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeFileDownloader
implements Runnable,
ProgressListener {
    private static final Logger log = LoggerFactory.getLogger(LargeFileDownloader.class);
    public static final int DEFAULT_PARALLEL_THRESHOLD = 0x8000000;
    public static final int MIN_PART_SIZE = 0x200000;
    public static final int DEFAULT_PART_SIZE = 0x2000000;
    public static final int DEFAULT_THREADS = 8;
    private S3Client s3Client;
    private String bucket;
    private String key;
    private File file;
    private Long objectSize;
    private AtomicLong bytesTransferred = new AtomicLong();
    private long parallelThreshold = 0x8000000L;
    private long partSize = 0x2000000L;
    private int threads = 8;
    private ExecutorService executorService;
    private ProgressListener progressListener;

    public LargeFileDownloader(S3Client s3Client, String bucket, String key, File file) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.key = key;
        this.file = file;
    }

    @Override
    public void progress(long completed, long total) {
    }

    @Override
    public void transferred(long size) {
        long totalTransferred = this.bytesTransferred.addAndGet(size);
        if (this.progressListener != null) {
            this.progressListener.transferred(size);
            this.progressListener.progress(totalTransferred, this.objectSize);
        }
    }

    @Override
    public void run() {
        this.download();
    }

    public void download() {
        try {
            S3ObjectMetadata metadata = this.s3Client.getObjectMetadata(this.bucket, this.key);
            this.objectSize = metadata.getContentLength();
            if (this.objectSize >= this.parallelThreshold) {
                this.doParallelDownload();
            } else {
                this.doSingleDownload();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error downloading file", e);
        }
    }

    protected void doSingleDownload() throws IOException {
        OutputStream os = new FileOutputStream(this.file);
        os = new ProgressOutputStream(os, this);
        StreamUtil.copy(this.s3Client.readObjectStream(this.bucket, this.key, null), os, this.objectSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doParallelDownload() throws Exception {
        if (this.file.exists() && !this.file.canWrite()) {
            throw new IllegalArgumentException("cannot write to file: " + this.file.getPath());
        }
        if (this.partSize < 0x200000L) {
            log.warn(String.format("%,dk is below the minimum part size (%,dk). the minimum will be used instead", this.partSize / 1024L, 2048));
            this.partSize = 0x200000L;
        }
        boolean shutdownThreadPool = false;
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.threads);
            shutdownThreadPool = true;
        }
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try {
            RandomAccessFile raFile = new RandomAccessFile(this.file, "rw");
            raFile.setLength(this.objectSize);
            FileChannel channel = raFile.getChannel();
            long length = this.partSize;
            for (long offset = 0L; offset < this.objectSize; offset += length) {
                if (offset + length > this.objectSize) {
                    length = this.objectSize - offset;
                }
                futures.add(this.executorService.submit(new DownloadPartTask(Range.fromOffsetLength(offset, length), channel)));
            }
            for (Future future : futures) {
                future.get();
            }
            raFile.close();
        }
        finally {
            if (shutdownThreadPool) {
                this.executorService.shutdown();
            }
        }
    }

    public S3Client getS3Client() {
        return this.s3Client;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public File getFile() {
        return this.file;
    }

    public Long getObjectSize() {
        return this.objectSize;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred.get();
    }

    public long getParallelThreshold() {
        return this.parallelThreshold;
    }

    public void setParallelThreshold(long parallelThreshold) {
        this.parallelThreshold = parallelThreshold;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public LargeFileDownloader withParallelThreshold(long parallelThreshold) {
        this.setParallelThreshold(parallelThreshold);
        return this;
    }

    public LargeFileDownloader withPartSize(long partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public LargeFileDownloader withThreads(int threads) {
        this.setThreads(threads);
        return this;
    }

    public LargeFileDownloader withExecutorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public LargeFileDownloader withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    protected class DownloadPartTask
    implements Callable<Void> {
        private Range range;
        private FileChannel channel;

        public DownloadPartTask(Range range, FileChannel channel) {
            this.range = range;
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            InputStream is = LargeFileDownloader.this.s3Client.readObjectStream(LargeFileDownloader.this.bucket, LargeFileDownloader.this.key, this.range);
            try {
                is = new ProgressInputStream(is, LargeFileDownloader.this);
                byte[] buffer = new byte[32768];
                long pos = this.range.getFirst();
                int r = 0;
                while (r != -1) {
                    this.channel.write(ByteBuffer.wrap(buffer, 0, r), pos);
                    pos += (long)r;
                    r = is.read(buffer);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable t) {
                    log.warn("could not close object stream", t);
                }
            }
        }
    }
}

