/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.jersey.BucketFilter;
import com.emc.object.s3.jersey.NamespaceFilter;
import com.emc.object.s3.request.PresignedUrlRequest;
import com.emc.object.shadow.org.apache.commons.codec.binary.Base64;
import com.emc.object.util.RestUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3SignerV2 {
    private static final Logger log = LoggerFactory.getLogger(S3SignerV2.class);
    private S3Config s3Config;
    private SortedSet<String> signedParameters;

    public S3SignerV2(S3Config s3Config) {
        this.s3Config = s3Config;
        this.signedParameters = new TreeSet<String>(Arrays.asList("acl", "torrent", "logging", "location", "policy", "requestPayment", "versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "delete", "lifecycle", "tagging", "cors", "restore", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires", "endpoint", "isstaleallowed"));
        if (s3Config.isSignMetadataSearch()) {
            this.signedParameters.add("query");
            this.signedParameters.add("searchmetadata");
        }
    }

    public void sign(String method, String resource, Map<String, String> parameters, Map<String, List<Object>> headers) {
        if (this.s3Config.getSessionToken() != null) {
            RestUtil.putSingle(headers, "x-amz-security-token", this.s3Config.getSessionToken());
        }
        String stringToSign = this.getStringToSign(method, resource, parameters, headers);
        String signature = this.getSignature(stringToSign);
        RestUtil.putSingle(headers, "Authorization", "AWS " + this.s3Config.getIdentity() + ":" + signature);
    }

    public URL generatePresignedUrl(PresignedUrlRequest request) {
        String namespace = request.getNamespace() != null ? request.getNamespace() : this.s3Config.getNamespace();
        URI uri = this.s3Config.resolvePath(request.getPath(), null);
        String resource = "/" + request.getBucketName() + RestUtil.getEncodedPath(uri);
        if (namespace != null) {
            if (this.s3Config.isUseVHost()) {
                uri = NamespaceFilter.insertNamespace(uri, namespace);
                if (this.s3Config.isSignNamespace()) {
                    resource = "/" + namespace + resource;
                }
            } else {
                log.warn("vHost namespace is disabled, so there is no way to specify a namespace in a pre-signed URL");
            }
        }
        uri = BucketFilter.insertBucket(uri, request.getBucketName(), this.s3Config.isUseVHost());
        Map<String, String> queryParams = request.getQueryParams();
        queryParams.put("AWSAccessKeyId", this.s3Config.getIdentity());
        if (this.s3Config.getSessionToken() != null) {
            queryParams.put("x-amz-security-token", this.s3Config.getSessionToken());
        }
        String stringToSign = this.getStringToSign(request.getMethod().toString(), resource, queryParams, request.getHeaders());
        String signature = this.getSignature(stringToSign);
        queryParams.put("Signature", signature);
        String subresource = request.getSubresource() != null ? request.getSubresource() + "&" : "";
        try {
            return new URL(uri + "?" + subresource + RestUtil.generateRawQueryString(queryParams));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("generated URL is not well-formed");
        }
    }

    public String getStringToSign(String method, String resource, Map<String, String> parameters, Map<String, List<Object>> headers) {
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(method).append("\n");
        String contentMd5 = RestUtil.getFirstAsString(headers, "Content-MD5");
        if (contentMd5 != null) {
            stringToSign.append(contentMd5);
        }
        stringToSign.append("\n");
        String contentType = RestUtil.getFirstAsString(headers, "Content-Type");
        if (contentType != null) {
            stringToSign.append(contentType);
        }
        stringToSign.append("\n");
        String date = RestUtil.getFirstAsString(headers, "Date");
        if (date == null) {
            date = RestUtil.getRequestDate(this.s3Config.getServerClockSkew());
            RestUtil.putSingle(headers, "Date", date);
        }
        if (headers.containsKey("x-amz-date")) {
            date = "";
        }
        if (parameters.containsKey("Expires")) {
            date = parameters.get("Expires");
        }
        stringToSign.append(date);
        stringToSign.append("\n");
        SortedMap<String, String> canonicalizedHeaders = this.getCanonicalizedHeaders(headers, parameters);
        for (String string : canonicalizedHeaders.keySet()) {
            stringToSign.append(string).append(":").append(((String)canonicalizedHeaders.get(string)).trim());
            stringToSign.append("\n");
        }
        stringToSign.append(resource);
        boolean firstParameter = true;
        for (String parameter : this.signedParameters) {
            if (!parameters.containsKey(parameter)) continue;
            stringToSign.append(firstParameter ? "?" : "&").append(parameter);
            String value = parameters.get(parameter);
            if (value != null) {
                stringToSign.append("=").append(value);
            }
            firstParameter = false;
        }
        String string = stringToSign.toString();
        log.debug("stringToSign:\n" + string);
        return string;
    }

    private SortedMap<String, String> getCanonicalizedHeaders(Map<String, List<Object>> headers, Map<String, String> parameters) {
        TreeMap<String, String> canonicalizedHeaders = new TreeMap<String, String>();
        for (String header : headers.keySet()) {
            String lcHeader = header.toLowerCase();
            if (!lcHeader.startsWith("x-amz-") && !lcHeader.startsWith("x-emc-")) continue;
            canonicalizedHeaders.put(lcHeader, this.trimAndJoin(headers.get(header), ","));
        }
        for (String parameter : parameters.keySet()) {
            String lcParameter = parameter.toLowerCase();
            if (!lcParameter.startsWith("x-amz-")) continue;
            canonicalizedHeaders.put(lcParameter, parameters.get(parameter));
        }
        return canonicalizedHeaders;
    }

    private String trimAndJoin(List<Object> values, String delimiter) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        StringBuilder delimited = new StringBuilder();
        Iterator<Object> valuesI = values.iterator();
        while (valuesI.hasNext()) {
            delimited.append(valuesI.next().toString().trim());
            if (!valuesI.hasNext()) continue;
            delimited.append(delimiter);
        }
        return delimited.toString();
    }

    public String getSignature(String stringToSign) {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(this.s3Config.getSecretKey().getBytes("UTF-8"), "HmacSHA1"));
            String signature = new String(Base64.encodeBase64(mac.doFinal(stringToSign.getBytes("UTF-8"))));
            log.debug("signature:\n" + signature);
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("HmacSHA1 algorithm is not supported on this platform", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported on this platform", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("The secret key \"" + this.s3Config.getSecretKey() + "\" is not valid", e);
        }
    }
}

