/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.bean;

import com.emc.object.s3.bean.CanonicalUser;
import com.emc.object.s3.bean.EncodingType;
import com.emc.object.s3.bean.StorageClass;
import com.emc.object.s3.bean.UrlEncodable;
import com.emc.object.util.RestUtil;
import java.util.Date;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class S3Object {
    private String key;
    private Date lastModified;
    private String eTag;
    private Long size;
    private StorageClass storageClass;
    private CanonicalUser owner;

    void _afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (parent instanceof UrlEncodable && ((UrlEncodable)parent).getEncodingType() == EncodingType.url) {
            this.key = RestUtil.urlDecode(this.key, false);
        }
    }

    @XmlElement(name="Key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @XmlElement(name="LastModified")
    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @XmlElement(name="ETag")
    public String getETag() {
        return this.eTag;
    }

    @XmlTransient
    public String getRawETag() {
        return RestUtil.stripQuotes(this.eTag);
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    @XmlElement(name="Size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @XmlElement(name="StorageClass")
    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    @XmlElement(name="Owner")
    public CanonicalUser getOwner() {
        return this.owner;
    }

    public void setOwner(CanonicalUser owner) {
        this.owner = owner;
    }
}

