/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientHandlerException;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientRequest;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientResponse;
import com.emc.object.shadow.com.sun.jersey.api.client.filter.ClientFilter;
import com.emc.object.util.RestUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(BucketFilter.class);
    private S3Config s3Config;

    public static URI insertBucket(URI uri, String bucketName, boolean useVHost) {
        try {
            if (useVHost) {
                String hostname = bucketName + "." + uri.getHost();
                uri = RestUtil.replaceHost(uri, hostname);
            } else {
                String resource = "/" + bucketName;
                if (!uri.getPath().isEmpty() && !"/".equals(uri.getPath())) {
                    resource = resource + uri.getPath();
                }
                uri = RestUtil.replacePath(uri, resource);
            }
            log.debug("URI including bucket: " + uri);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("bucket name \"%s\" generated an invalid URI", bucketName), e);
        }
    }

    public BucketFilter(S3Config s3Config) {
        this.s3Config = s3Config;
    }

    @Override
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        URI uri = request.getURI();
        String bucketName = (String)request.getProperties().get("com.emc.object.s3.bucketName");
        if (bucketName != null) {
            request.setURI(BucketFilter.insertBucket(uri, bucketName, this.s3Config.isUseVHost()));
        }
        return this.getNext().handle(request);
    }
}

