/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.codec.CodecChain;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.shadow.com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientHandlerException;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientRequest;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientRequestAdapter;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientResponse;
import com.emc.object.shadow.com.sun.jersey.api.client.filter.ClientFilter;
import com.emc.object.shadow.javax.ws.rs.core.MultivaluedMap;
import com.emc.rest.smart.SizeOverrideWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(CodecFilter.class);
    private CodecChain encodeChain;
    private Map<String, Object> codecProperties;

    public CodecFilter(CodecChain encodeChain) {
        this.encodeChain = encodeChain;
    }

    @Override
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse response;
        Map userMeta = (Map)request.getProperties().get("com.emc.object.userMetadata");
        HashMap metaBackup = null;
        Boolean encode = (Boolean)request.getProperties().get("com.emc.object.codec.encodeEntity");
        if (encode != null && encode.booleanValue()) {
            Long originalSize = SizeOverrideWriter.getEntitySize();
            if (this.encodeChain.isSizePredictable() && originalSize != null) {
                long encodedSize = this.encodeChain.getEncodedSize(originalSize);
                log.debug("updating content-length for encoded data (original: {}, encoded: {})", (Object)originalSize, (Object)encodedSize);
                SizeOverrideWriter.setEntitySize(encodedSize);
            } else {
                SizeOverrideWriter.setEntitySize(-1L);
            }
            metaBackup = new HashMap(userMeta);
            DanglingOutputStream danglingStream = new DanglingOutputStream();
            OutputStream encodeStream = this.encodeChain.getEncodeStream(danglingStream, (Map<String, String>)userMeta);
            request.getHeaders().putAll(S3ObjectMetadata.getUmdHeaders(userMeta));
            request.setAdapter(new EncryptAdapter(request.getAdapter(), danglingStream, encodeStream));
        }
        try {
            response = this.getNext().handle(request);
        }
        catch (RuntimeException e) {
            if (encode != null && encode.booleanValue()) {
                userMeta.clear();
                userMeta.putAll(metaBackup);
            }
            throw e;
        }
        MultivaluedMap<String, String> headers = response.getHeaders();
        Map<String, String> storedMeta = S3ObjectMetadata.getUserMetadata(headers);
        HashSet<String> keysToRemove = new HashSet<String>();
        keysToRemove.addAll(storedMeta.keySet());
        String[] encodeSpecs = CodecChain.getEncodeSpecs(storedMeta);
        if (encodeSpecs != null) {
            CodecChain decodeChain = new CodecChain(encodeSpecs).withProperties(this.codecProperties);
            Boolean decode = (Boolean)request.getProperties().get("com.emc.object.codec.decodeEntity");
            if (decode != null && decode.booleanValue()) {
                response.setEntityInputStream(decodeChain.getDecodeStream(response.getEntityInputStream(), storedMeta));
            } else {
                decodeChain.removeEncodeMetadata(storedMeta, decodeChain.getEncodeMetadataList(storedMeta));
            }
            Boolean keepHeaders = (Boolean)request.getProperties().get("com.emc.object.codec.keepEncodeHeaders");
            if (keepHeaders == null || !keepHeaders.booleanValue()) {
                keysToRemove.removeAll(storedMeta.keySet());
                for (String key : keysToRemove) {
                    headers.remove(S3ObjectMetadata.getHeaderName(key));
                }
            }
        }
        return response;
    }

    public Map<String, Object> getCodecProperties() {
        return this.codecProperties;
    }

    public void setCodecProperties(Map<String, Object> codecProperties) {
        this.codecProperties = codecProperties;
    }

    public CodecFilter withCodecProperties(Map<String, Object> codecProperties) {
        this.setCodecProperties(codecProperties);
        return this;
    }

    private static class DanglingOutputStream
    extends FilterOutputStream {
        private static final OutputStream BOGUS_STREAM = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new RuntimeException("you didn't connect a dangling output stream!");
            }
        };

        DanglingOutputStream() {
            super(BOGUS_STREAM);
        }

        void setOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("single-byte write called!");
        }
    }

    private class EncryptAdapter
    extends AbstractClientRequestAdapter {
        DanglingOutputStream danglingStream;
        OutputStream encodeStream;

        EncryptAdapter(ClientRequestAdapter parent, DanglingOutputStream danglingStream, OutputStream encodeStream) {
            super(parent);
            this.danglingStream = danglingStream;
            this.encodeStream = encodeStream;
        }

        @Override
        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            this.danglingStream.setOutputStream(out);
            return this.getAdapter().adapt(request, this.encodeStream);
        }
    }
}

