/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Exception;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientHandlerException;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientRequest;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientResponse;
import com.emc.object.shadow.com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Random;

public class FaultInjectionFilter
extends ClientFilter {
    public static final String FAULT_INJECTION_ERROR_CODE = "FaultInjection";
    public static final String FAULT_INJECTION_ERROR_MESSAGE = "Fault Injection";
    public static final float DEFAULT_FAILURE_RATE = 0.25f;
    private Random random = new Random();
    private float failureRate;

    public FaultInjectionFilter() {
        this(0.25f);
    }

    public FaultInjectionFilter(float failureRate) {
        this.failureRate = failureRate;
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (this.random.nextFloat() < this.failureRate) {
            throw new S3Exception(FAULT_INJECTION_ERROR_MESSAGE, 500, FAULT_INJECTION_ERROR_CODE, null);
        }
        return this.getNext().handle(cr);
    }

    public float getFailureRate() {
        return this.failureRate;
    }
}

