/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.Method;
import com.emc.object.ObjectConfig;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientHandlerException;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientRequest;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientResponse;
import com.emc.object.shadow.com.sun.jersey.api.client.filter.ClientFilter;
import com.emc.object.util.GeoPinningUtil;
import com.emc.rest.smart.ecs.Vdc;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPinningFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(GeoPinningFilter.class);
    private final ObjectConfig<?> objectConfig;

    public GeoPinningFilter(ObjectConfig<?> objectConfig) {
        this.objectConfig = objectConfig;
    }

    @Override
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        String bucketName = (String)request.getProperties().get("com.emc.object.s3.bucketName");
        String objectKey = (String)request.getProperties().get("com.emc.object.s3.objectKey");
        if (bucketName != null) {
            Integer retries;
            ArrayList<Vdc> healthyVdcs = new ArrayList<Vdc>();
            for (Vdc vdc : this.objectConfig.getVdcs()) {
                if (!vdc.isHealthy()) continue;
                healthyVdcs.add(vdc);
            }
            if (healthyVdcs.isEmpty()) {
                log.debug("there are no healthy VDCs; geo-pinning will include all VDCs");
                healthyVdcs.addAll(this.objectConfig.getVdcs());
            }
            int geoPinIndex = GeoPinningUtil.getGeoPinIndex(GeoPinningUtil.getGeoId(bucketName, objectKey), healthyVdcs.size());
            if (this.objectConfig.isGeoReadRetryFailover() && Method.GET.name().equalsIgnoreCase(request.getMethod()) && (retries = (Integer)request.getProperties().get("com.emc.object.retryCount")) != null) {
                int newIndex = (geoPinIndex + retries) % healthyVdcs.size();
                log.info("geo-pin read retry #{}: failing over from primary VDC {} to VDC {}", new Object[]{retries, geoPinIndex, newIndex});
                geoPinIndex = newIndex;
            }
            request.getProperties().put("com.emc.object.geoPinnedVdc", healthyVdcs.get(geoPinIndex));
        }
        return this.getNext().handle(request);
    }

    public ObjectConfig<?> getObjectConfig() {
        return this.objectConfig;
    }
}

