/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.EntityRequest;
import com.emc.object.Method;
import com.emc.object.s3.bean.DeleteObjects;
import com.emc.object.s3.bean.ObjectKey;
import com.emc.object.s3.request.AbstractBucketRequest;
import com.emc.object.util.RestUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DeleteObjectsRequest
extends AbstractBucketRequest
implements EntityRequest {
    private DeleteObjects deleteObjects;
    private Boolean bypassGovernanceRetention;

    public DeleteObjectsRequest(String bucketName) {
        super(Method.POST, bucketName, "", "delete");
        this.property("com.emc.object.generateContentMd5", Boolean.TRUE);
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.bypassGovernanceRetention != null) {
            RestUtil.putSingle(headers, "x-amz-bypass-governance-retention", this.bypassGovernanceRetention.toString());
        }
        return headers;
    }

    @Override
    public Object getEntity() {
        return this.getDeleteObjects();
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public Long getContentLength() {
        return null;
    }

    @Override
    public boolean isChunkable() {
        return false;
    }

    public DeleteObjects getDeleteObjects() {
        return this.deleteObjects;
    }

    public void setDeleteObjects(DeleteObjects deleteObjects) {
        this.deleteObjects = deleteObjects;
    }

    public synchronized DeleteObjectsRequest withKeys(List<ObjectKey> keys) {
        if (this.deleteObjects == null) {
            this.deleteObjects = new DeleteObjects();
        }
        this.deleteObjects.setKeys(keys);
        return this;
    }

    public DeleteObjectsRequest withKeys(ObjectKey ... keys) {
        return this.withKeys(Arrays.asList(keys));
    }

    public DeleteObjectsRequest withKeys(String ... keys) {
        ObjectKey[] objects = new ObjectKey[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            objects[i] = new ObjectKey(keys[i]);
        }
        return this.withKeys(objects);
    }

    public boolean getBypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    public void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
        this.bypassGovernanceRetention = bypassGovernanceRetention;
    }

    public DeleteObjectsRequest withBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
        this.setBypassGovernanceRetention(bypassGovernanceRetention);
        return this;
    }
}

