/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.shadow.com.sun.jersey.client.apache4;

import com.emc.object.shadow.com.sun.jersey.api.client.ClientHandlerException;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientRequest;
import com.emc.object.shadow.com.sun.jersey.api.client.ClientResponse;
import com.emc.object.shadow.com.sun.jersey.api.client.RequestWriter;
import com.emc.object.shadow.com.sun.jersey.api.client.TerminatingClientHandler;
import com.emc.object.shadow.com.sun.jersey.core.header.InBoundHeaders;
import com.emc.object.shadow.com.sun.jersey.core.util.ReaderWriter;
import com.emc.object.shadow.javax.ws.rs.core.MultivaluedMap;
import com.emc.object.shadow.org.apache.http.Header;
import com.emc.object.shadow.org.apache.http.HttpEntity;
import com.emc.object.shadow.org.apache.http.HttpHost;
import com.emc.object.shadow.org.apache.http.HttpRequest;
import com.emc.object.shadow.org.apache.http.HttpResponse;
import com.emc.object.shadow.org.apache.http.client.CookieStore;
import com.emc.object.shadow.org.apache.http.client.HttpClient;
import com.emc.object.shadow.org.apache.http.client.methods.HttpDelete;
import com.emc.object.shadow.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.emc.object.shadow.org.apache.http.client.methods.HttpGet;
import com.emc.object.shadow.org.apache.http.client.methods.HttpHead;
import com.emc.object.shadow.org.apache.http.client.methods.HttpOptions;
import com.emc.object.shadow.org.apache.http.client.methods.HttpPost;
import com.emc.object.shadow.org.apache.http.client.methods.HttpPut;
import com.emc.object.shadow.org.apache.http.client.methods.HttpRequestBase;
import com.emc.object.shadow.org.apache.http.client.methods.HttpUriRequest;
import com.emc.object.shadow.org.apache.http.entity.AbstractHttpEntity;
import com.emc.object.shadow.org.apache.http.entity.BufferedHttpEntity;
import com.emc.object.shadow.org.apache.http.impl.auth.BasicScheme;
import com.emc.object.shadow.org.apache.http.impl.client.BasicAuthCache;
import com.emc.object.shadow.org.apache.http.protocol.BasicHttpContext;
import com.emc.object.shadow.org.apache.http.protocol.HttpContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ApacheHttpClient4Handler
extends TerminatingClientHandler {
    private final HttpClient client;
    private final CookieStore cookieStore;
    private final boolean preemptiveBasicAuth;

    public ApacheHttpClient4Handler(HttpClient client, CookieStore cookieStore, boolean preemptiveBasicAuth) {
        this.client = client;
        this.cookieStore = cookieStore;
        this.preemptiveBasicAuth = preemptiveBasicAuth;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        HttpUriRequest request = this.getUriHttpRequest(cr);
        this.writeOutBoundHeaders(cr.getHeaders(), request);
        try {
            HttpResponse response;
            if (this.preemptiveBasicAuth) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicScheme = new BasicScheme();
                authCache.put(this.getHost(request), basicScheme);
                BasicHttpContext localContext = new BasicHttpContext();
                localContext.setAttribute("http.auth.auth-cache", authCache);
                response = this.getHttpClient().execute(this.getHost(request), (HttpRequest)request, (HttpContext)localContext);
            } else {
                response = this.getHttpClient().execute(this.getHost(request), request);
            }
            ClientResponse r = new ClientResponse(response.getStatusLine().getStatusCode(), this.getInBoundHeaders(response), (InputStream)new HttpClientResponseInputStream(response), this.getMessageBodyWorkers());
            if (!r.hasEntity()) {
                r.bufferEntity();
                r.close();
            }
            return r;
        }
        catch (Exception e) {
            throw new ClientHandlerException(e);
        }
    }

    private Boolean isBufferingEnabled(ClientRequest cr) {
        Boolean enabled = (Boolean)cr.getProperties().get("com.emc.object.shadow.com.sun.jersey.impl.client.httpclient.enableBuffering");
        return enabled != null && enabled != false;
    }

    private HttpHost getHost(HttpUriRequest request) {
        return new HttpHost(request.getURI().getHost(), request.getURI().getPort(), request.getURI().getScheme());
    }

    private HttpUriRequest getUriHttpRequest(ClientRequest cr) {
        Integer chunkSize;
        final String strMethod = cr.getMethod();
        final URI uri = cr.getURI();
        Boolean bufferingEnabled = this.isBufferingEnabled(cr);
        HttpEntity entity = this.getHttpEntity(cr, bufferingEnabled);
        HttpRequestBase request = strMethod.equals("GET") ? new HttpGet(uri) : (strMethod.equals("POST") ? new HttpPost(uri) : (strMethod.equals("PUT") ? new HttpPut(uri) : (strMethod.equals("DELETE") ? new HttpDelete(uri) : (strMethod.equals("HEAD") ? new HttpHead(uri) : (strMethod.equals("OPTIONS") ? new HttpOptions(uri) : new HttpEntityEnclosingRequestBase(){

            @Override
            public String getMethod() {
                return strMethod;
            }

            @Override
            public URI getURI() {
                return uri;
            }
        })))));
        if (entity != null && request instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)request).setEntity(entity);
        } else if (entity != null) {
            throw new ClientHandlerException("Adding entity to http method " + cr.getMethod() + " is not supported.");
        }
        Integer readTimeout = (Integer)cr.getProperties().get("com.emc.object.shadow.com.sun.jersey.client.property.readTimeout");
        if (readTimeout != null) {
            request.getParams().setIntParameter("http.socket.timeout", readTimeout);
        }
        if ((chunkSize = (Integer)cr.getProperties().get("com.emc.object.shadow.com.sun.jersey.client.property.chunkedEncodingSize")) != null && !bufferingEnabled.booleanValue()) {
            this.client.getParams().setIntParameter("http.connection.min-chunk-limit", chunkSize);
        }
        return request;
    }

    private HttpEntity getHttpEntity(ClientRequest cr, final boolean isBufferingEnabled) {
        Object entity = cr.getEntity();
        if (entity == null) {
            return null;
        }
        final RequestWriter.RequestEntityWriter requestEntityWriter = this.getRequestEntityWriter(cr);
        try {
            AbstractHttpEntity httpEntity = new AbstractHttpEntity(){

                @Override
                public boolean isRepeatable() {
                    return false;
                }

                @Override
                public long getContentLength() {
                    return requestEntityWriter.getSize();
                }

                @Override
                public InputStream getContent() throws IOException, IllegalStateException {
                    if (isBufferingEnabled) {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
                        this.writeTo(buffer);
                        return new ByteArrayInputStream(buffer.toByteArray());
                    }
                    return null;
                }

                @Override
                public void writeTo(OutputStream outputStream) throws IOException {
                    requestEntityWriter.writeRequestEntity(outputStream);
                }

                @Override
                public boolean isStreaming() {
                    return false;
                }
            };
            if (!isBufferingEnabled) {
                return httpEntity;
            }
            return new BufferedHttpEntity(httpEntity);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, Object> headers, HttpUriRequest request) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                request.addHeader((String)e.getKey(), ClientRequest.getHeaderValue(vs.get(0)));
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(ClientRequest.getHeaderValue(v));
            }
            request.addHeader((String)e.getKey(), b.toString());
        }
    }

    private InBoundHeaders getInBoundHeaders(HttpResponse response) {
        Header[] respHeaders;
        InBoundHeaders headers = new InBoundHeaders();
        for (Header header : respHeaders = response.getAllHeaders()) {
            ArrayList<String> list = (ArrayList<String>)headers.get(header.getName());
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(header.getValue());
            headers.put(header.getName(), list);
        }
        return headers;
    }

    private static InputStream getInputStream(HttpResponse response) throws IOException {
        if (response.getEntity() == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        InputStream i = response.getEntity().getContent();
        if (i.markSupported()) {
            return i;
        }
        return new BufferedInputStream(i, ReaderWriter.BUFFER_SIZE);
    }

    private static final class HttpClientResponseInputStream
    extends FilterInputStream {
        HttpClientResponseInputStream(HttpResponse response) throws IOException {
            super(ApacheHttpClient4Handler.getInputStream(response));
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

