/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.shadow.org.apache.http.client.protocol;

import com.emc.object.shadow.org.apache.http.Header;
import com.emc.object.shadow.org.apache.http.HeaderElement;
import com.emc.object.shadow.org.apache.http.HttpEntity;
import com.emc.object.shadow.org.apache.http.HttpException;
import com.emc.object.shadow.org.apache.http.HttpResponse;
import com.emc.object.shadow.org.apache.http.HttpResponseInterceptor;
import com.emc.object.shadow.org.apache.http.annotation.Contract;
import com.emc.object.shadow.org.apache.http.annotation.ThreadingBehavior;
import com.emc.object.shadow.org.apache.http.client.config.RequestConfig;
import com.emc.object.shadow.org.apache.http.client.entity.DecompressingEntity;
import com.emc.object.shadow.org.apache.http.client.entity.DeflateInputStreamFactory;
import com.emc.object.shadow.org.apache.http.client.entity.GZIPInputStreamFactory;
import com.emc.object.shadow.org.apache.http.client.entity.InputStreamFactory;
import com.emc.object.shadow.org.apache.http.client.protocol.HttpClientContext;
import com.emc.object.shadow.org.apache.http.config.Lookup;
import com.emc.object.shadow.org.apache.http.config.RegistryBuilder;
import com.emc.object.shadow.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIPInputStreamFactory.getInstance()).register("x-gzip", GZIPInputStreamFactory.getInstance()).register("deflate", (GZIPInputStreamFactory)((Object)DeflateInputStreamFactory.getInstance())).build();
        this.ignoreUnknown = ignoreUnknown;
    }

    public ResponseContentEncoding(boolean ignoreUnknown) {
        this(null, ignoreUnknown);
    }

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this(decoderRegistry, true);
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + codec.getName());
            }
        }
    }
}

