/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.shadow.org.dom4j.util;

import com.emc.object.shadow.org.dom4j.util.SingletonStrategy;
import java.lang.ref.WeakReference;

public class PerThreadSingleton<T>
implements SingletonStrategy<T> {
    private String singletonClassName = null;
    private ThreadLocal<WeakReference<T>> perThreadCache = new ThreadLocal();

    @Override
    public void reset() {
        this.perThreadCache = new ThreadLocal();
    }

    @Override
    public T instance() {
        Object singletonInstancePerThread = null;
        WeakReference<T> ref = this.perThreadCache.get();
        if (ref == null || ref.get() == null) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(this.singletonClassName);
                singletonInstancePerThread = clazz.newInstance();
            }
            catch (Exception ignore) {
                try {
                    clazz = Class.forName(this.singletonClassName);
                    singletonInstancePerThread = clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.perThreadCache.set(new WeakReference<Object>(singletonInstancePerThread));
        } else {
            singletonInstancePerThread = ref.get();
        }
        return singletonInstancePerThread;
    }

    @Override
    public void setSingletonClassName(String singletonClassName) {
        this.singletonClassName = singletonClassName;
    }
}

