/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.util;

import com.emc.object.util.ChecksumAlgorithm;
import com.emc.object.util.ChecksumValue;
import com.emc.object.util.RunningChecksum;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class ChecksummedOutputStream
extends OutputStream {
    private OutputStream delegate;
    private RunningChecksum checksum;

    public ChecksummedOutputStream(OutputStream delegate, ChecksumAlgorithm algorithm) throws NoSuchAlgorithmException {
        this(delegate, new RunningChecksum(algorithm));
    }

    public ChecksummedOutputStream(OutputStream delegate, RunningChecksum checksum) {
        this.delegate = delegate;
        this.checksum = checksum;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.update(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public ChecksumValue getChecksum() {
        return this.checksum;
    }

    private void update(byte[] bytes, int offset, int length) {
        this.checksum.update(bytes, offset, length);
    }
}

