/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.util;

import com.emc.object.shadow.com.sun.jersey.core.util.MultivaluedMapImpl;
import com.emc.object.shadow.javax.ws.rs.core.MultivaluedMap;
import com.emc.object.util.ConfigUriProperty;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUri<C> {
    private static final Logger log = LoggerFactory.getLogger(ConfigUri.class);
    private static final Map<Class<?>, PropertyConverter> converterClassMap = new HashMap();
    private Class<C> targetClass;
    private PropertyDescriptor protocolProperty;
    private PropertyDescriptor hostProperty;
    private PropertyDescriptor portProperty;
    private PropertyDescriptor pathProperty;
    private Map<String, PropertyDescriptor> paramPropertyMap = new TreeMap<String, PropertyDescriptor>();
    private Map<String, PropertyDescriptor> mapPropertyMap = new TreeMap<String, PropertyDescriptor>();
    private Map<PropertyDescriptor, PropertyConverter> converterMap = new HashMap<PropertyDescriptor, PropertyConverter>();
    private static final Pattern PARAM_PATTERN;

    public static void registerConverter(Class<?> type, PropertyConverter converter) {
        converterClassMap.put(type, converter);
    }

    public ConfigUri(Class<C> targetClass) {
        try {
            this.targetClass = targetClass;
            BeanInfo beanInfo = Introspector.getBeanInfo(targetClass);
            boolean annotationPresent = false;
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                if (!descriptor.getReadMethod().isAnnotationPresent(ConfigUriProperty.class)) continue;
                annotationPresent = true;
                ConfigUriProperty annotation = descriptor.getReadMethod().getAnnotation(ConfigUriProperty.class);
                switch (annotation.type()) {
                    case Protocol: {
                        if (this.protocolProperty != null) {
                            throw new IllegalArgumentException(targetClass.getSimpleName() + " has more than one Protocol binding");
                        }
                        if (descriptor.getPropertyType() != String.class && annotation.converter() == PropertyConverter.class) {
                            throw new IllegalArgumentException(String.format("%s.%s property type for Protocol should be String", targetClass.getSimpleName(), descriptor.getName()));
                        }
                        this.protocolProperty = descriptor;
                        break;
                    }
                    case Host: {
                        if (this.hostProperty != null) {
                            throw new IllegalArgumentException(targetClass.getSimpleName() + " has more than one Host binding");
                        }
                        if (descriptor.getPropertyType() != String.class && annotation.converter() == PropertyConverter.class) {
                            throw new IllegalArgumentException(String.format("%s.%s property type for Host should be String", targetClass.getSimpleName(), descriptor.getName()));
                        }
                        this.hostProperty = descriptor;
                        break;
                    }
                    case Port: {
                        if (this.portProperty != null) {
                            throw new IllegalArgumentException(targetClass.getSimpleName() + " has more than one Port binding");
                        }
                        if (descriptor.getPropertyType() != Integer.class && descriptor.getPropertyType() != Integer.TYPE && annotation.converter() == PropertyConverter.class) {
                            throw new IllegalArgumentException(String.format("%s.%s property type for Port should be int", targetClass.getSimpleName(), descriptor.getName()));
                        }
                        this.portProperty = descriptor;
                        break;
                    }
                    case Path: {
                        if (this.pathProperty != null) {
                            throw new IllegalArgumentException(targetClass.getSimpleName() + " has more than one Path binding");
                        }
                        if (descriptor.getPropertyType() != String.class && annotation.converter() == PropertyConverter.class) {
                            throw new IllegalArgumentException(String.format("%s.%s property type for Path should be String", targetClass.getSimpleName(), descriptor.getName()));
                        }
                        this.pathProperty = descriptor;
                        break;
                    }
                    case Parameter: {
                        String name;
                        String string = name = this.isNotBlank(annotation.param()) ? annotation.param() : descriptor.getName();
                        if (descriptor.getPropertyType() == Map.class) {
                            this.mapPropertyMap.put(name, descriptor);
                            break;
                        }
                        this.paramPropertyMap.put(name, descriptor);
                    }
                }
                if (annotation.converter() == PropertyConverter.class) continue;
                this.converterMap.put(descriptor, annotation.converter().newInstance());
            }
            if (!annotationPresent) {
                log.warn("no @ConfigUriProperty annotations found on getters in {}", (Object)targetClass.getSimpleName());
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public C parseUri(String configUri) {
        return this.parseUri(configUri, null);
    }

    public C parseUri(String configUri, C defaults) {
        return this.parseUri(configUri, defaults, false);
    }

    public C parseUri(String configUri, C defaultObject, boolean strict) {
        try {
            URI uriObj = new URI(configUri);
            C object = this.targetClass.newInstance();
            if (defaultObject != null) {
                Object defaultValue;
                for (PropertyDescriptor descriptor : this.paramPropertyMap.values()) {
                    defaultValue = descriptor.getReadMethod().invoke(defaultObject, new Object[0]);
                    descriptor.getWriteMethod().invoke(object, defaultValue);
                }
                for (PropertyDescriptor descriptor : this.mapPropertyMap.values()) {
                    defaultValue = descriptor.getReadMethod().invoke(defaultObject, new Object[0]);
                    descriptor.getWriteMethod().invoke(object, defaultValue);
                }
            }
            if (this.protocolProperty != null && uriObj.getScheme() != null) {
                this.setPropertyValues(object, this.protocolProperty, Collections.singletonList(uriObj.getScheme()));
            }
            if (this.hostProperty != null && uriObj.getHost() != null) {
                this.setPropertyValues(object, this.hostProperty, Collections.singletonList(uriObj.getHost()));
            }
            if (this.portProperty != null && uriObj.getPort() > 0) {
                this.setPropertyValues(object, this.portProperty, Collections.singletonList("" + uriObj.getPort()));
            }
            if (this.pathProperty != null && uriObj.getPath() != null) {
                this.setPropertyValues(object, this.pathProperty, Collections.singletonList(uriObj.getPath()));
            }
            MultivaluedMap<String, String> params = this.getParameterMap(uriObj.getQuery());
            for (String key : params.keySet()) {
                String baseName;
                if (this.paramPropertyMap.containsKey(key)) {
                    PropertyDescriptor descriptor = this.paramPropertyMap.get(key);
                    this.setPropertyValues(object, descriptor, (List)params.get(key));
                    continue;
                }
                String string = baseName = key.contains(".") ? key.substring(0, key.indexOf(".")) : key;
                if (this.mapPropertyMap.containsKey(baseName)) {
                    if (!key.contains(".") || key.length() < baseName.length() + 2) {
                        throw new IllegalArgumentException(String.format("map param %s.%s should have a period (.) and a sub-param", this.targetClass.getSimpleName(), key));
                    }
                    PropertyDescriptor descriptor = this.mapPropertyMap.get(baseName);
                    String subKey = key.substring(key.indexOf(".") + 1);
                    this.setMapValue(object, descriptor, subKey, (List)params.get(key));
                    continue;
                }
                if (!strict) continue;
                throw new IllegalArgumentException(String.format("param %s not found in class %s", key, object.getClass().getSimpleName()));
            }
            return object;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public String generateUri(C object) {
        return this.generateUri(object, null);
    }

    public String generateUri(C object, C defaultObject) {
        try {
            List<String> values;
            List<String> values2;
            List<String> values3;
            List<String> values4;
            String param;
            if (defaultObject == null) {
                defaultObject = this.targetClass.newInstance();
            }
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            for (Map.Entry<String, PropertyDescriptor> entry : this.paramPropertyMap.entrySet()) {
                List<String> defaultValues;
                param = entry.getKey();
                values4 = this.getPropertyValues(object, entry.getValue());
                if (values4 == null || values4.isEmpty() || values4.equals(defaultValues = this.getPropertyValues(defaultObject, entry.getValue()))) continue;
                params.put(param, values4);
            }
            for (Map.Entry<String, PropertyDescriptor> entry : this.mapPropertyMap.entrySet()) {
                Map<String, String> defaultValuesMap;
                param = entry.getKey();
                Map<String, String> valuesMap = this.getValueMap(object, entry.getValue());
                if (valuesMap == null || valuesMap.isEmpty() || valuesMap.equals(defaultValuesMap = this.getValueMap(defaultObject, entry.getValue()))) continue;
                for (String subKey : valuesMap.keySet()) {
                    params.put(param + "." + subKey, Collections.singletonList(valuesMap.get(subKey)));
                }
            }
            String scheme = null;
            if (this.protocolProperty != null && (values3 = this.getPropertyValues(object, this.protocolProperty)) != null && !values3.isEmpty()) {
                scheme = values3.get(0);
            }
            String host = null;
            if (this.hostProperty != null && (values2 = this.getPropertyValues(object, this.hostProperty)) != null && !values2.isEmpty()) {
                host = values2.get(0);
            }
            int port = -1;
            if (this.portProperty != null && (values4 = this.getPropertyValues(object, this.portProperty)) != null && !values4.isEmpty() && values4.get(0) != null) {
                port = Integer.parseInt(values4.get(0));
            }
            String path = null;
            if (this.pathProperty != null && (values = this.getPropertyValues(object, this.pathProperty)) != null && !values.isEmpty()) {
                path = values.get(0);
            }
            return new URI(scheme, null, host, port, path, this.getQuery(params), null).toString();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private MultivaluedMap<String, String> getParameterMap(String query) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (this.isNotBlank(query)) {
            String[] queryParts;
            for (String queryPart : queryParts = query.split("&")) {
                if (!this.isNotBlank(queryPart)) continue;
                Matcher m = PARAM_PATTERN.matcher(queryPart);
                if (!m.find()) {
                    throw new IllegalArgumentException("invalid parameter format: " + queryPart);
                }
                String param = m.group(1);
                String value = m.groupCount() > 1 ? m.group(2) : null;
                params.add(param, value);
            }
        }
        return params;
    }

    private String getQuery(MultivaluedMap<String, String> parameterMap) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (entry.getValue() != null) {
                int size = query.length();
                for (String value : (List)entry.getValue()) {
                    query.append((String)entry.getKey());
                    if (value != null) {
                        query.append("=").append(value);
                    }
                    query.append("&");
                }
                if (query.length() > size) {
                    query.deleteCharAt(query.length() - 1);
                }
            } else {
                query.append((String)entry.getKey());
            }
            query.append("&");
        }
        if (query.length() > 1) {
            query.deleteCharAt(query.length() - 1);
        }
        return query.toString();
    }

    private List<String> getPropertyValues(C object, PropertyDescriptor descriptor) {
        try {
            Object value = descriptor.getReadMethod().invoke(object, new Object[0]);
            if (value == null) {
                return null;
            }
            ArrayList<String> stringValues = new ArrayList<String>();
            if (value instanceof List) {
                for (Object element : (List)value) {
                    stringValues.add(this.findConverter(descriptor, element.getClass()).stringFromValue(element));
                }
            } else {
                stringValues.add(this.findConverter(descriptor).stringFromValue(value));
            }
            return stringValues;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getValueMap(C object, PropertyDescriptor descriptor) {
        try {
            Object value = descriptor.getReadMethod().invoke(object, new Object[0]);
            if (value == null) {
                return null;
            }
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException(String.format("%s.%s is supposed to be a map, but it's not", this.targetClass.getSimpleName(), descriptor.getName()));
            }
            TreeMap<String, String> valuesMap = new TreeMap<String, String>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                PropertyConverter converter = this.findConverter(descriptor, entry.getValue().getClass());
                valuesMap.put(entry.getKey().toString(), converter.stringFromValue(entry.getValue()));
            }
            return valuesMap;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyValues(C object, PropertyDescriptor descriptor, List<String> stringValues) {
        try {
            PropertyDescriptor propertyDescriptor = descriptor;
            synchronized (propertyDescriptor) {
                if (stringValues == null) {
                    descriptor.getWriteMethod().invoke(object, new Object[]{null});
                } else if (List.class == descriptor.getPropertyType()) {
                    ArrayList<Object> objects = new ArrayList<Object>();
                    for (String stringValue : stringValues) {
                        objects.add(this.findConverter(descriptor).valueFromString(stringValue));
                    }
                    descriptor.getWriteMethod().invoke(object, objects);
                } else {
                    if (stringValues.size() > 1) {
                        throw new IllegalArgumentException(String.format("cannot set multiple values to property %s.%s", this.targetClass.getSimpleName(), descriptor.getName()));
                    }
                    Object value = stringValues.isEmpty() ? null : this.findConverter(descriptor).valueFromString(stringValues.get(0));
                    descriptor.getWriteMethod().invoke(object, value);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMapValue(C object, PropertyDescriptor descriptor, String subKey, List<String> stringValues) {
        try {
            PropertyDescriptor propertyDescriptor = descriptor;
            synchronized (propertyDescriptor) {
                if (Map.class != descriptor.getPropertyType()) {
                    throw new IllegalArgumentException(String.format("%s.%s is supposed to be a map, but it's not", this.targetClass.getSimpleName(), descriptor.getName()));
                }
                if (stringValues != null && stringValues.size() > 1) {
                    throw new IllegalArgumentException(String.format("cannot set multiple values to map property %s.%s[%s]", this.targetClass.getSimpleName(), descriptor.getName(), subKey));
                }
                HashMap<String, Object> map = (HashMap<String, Object>)descriptor.getReadMethod().invoke(object, new Object[0]);
                if (map == null) {
                    map = new HashMap<String, Object>();
                    descriptor.getWriteMethod().invoke(object, map);
                }
                Object value = null;
                if (stringValues != null && stringValues.size() > 0) {
                    value = this.findConverter(descriptor).valueFromString(stringValues.get(0));
                }
                map.put(subKey, value);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private PropertyConverter findConverter(PropertyDescriptor descriptor) {
        return this.findConverter(descriptor, descriptor.getPropertyType());
    }

    private PropertyConverter findConverter(PropertyDescriptor descriptor, Class<?> type) {
        if (this.converterMap.containsKey(descriptor)) {
            return this.converterMap.get(descriptor);
        }
        if (converterClassMap.containsKey(type)) {
            return converterClassMap.get(type);
        }
        throw new UnsupportedOperationException(String.format("no property converter found for %s.%s of type %s", this.targetClass.getSimpleName(), descriptor.getName(), type.getSimpleName()));
    }

    private boolean isNotBlank(String string) {
        return string != null && !string.trim().isEmpty();
    }

    static {
        converterClassMap.put(String.class, new StringPropertyConverter());
        converterClassMap.put(Integer.class, new IntegerPropertyConverter());
        converterClassMap.put(Integer.TYPE, new IntegerPropertyConverter());
        converterClassMap.put(Long.class, new LongPropertyConverter());
        converterClassMap.put(Long.TYPE, new LongPropertyConverter());
        converterClassMap.put(Float.class, new FloatPropertyConverter());
        converterClassMap.put(Float.TYPE, new FloatPropertyConverter());
        converterClassMap.put(Boolean.class, new BooleanPropertyConverter());
        converterClassMap.put(Boolean.TYPE, new BooleanPropertyConverter());
        PARAM_PATTERN = Pattern.compile("^([^=]+)(?:=(.+))?$");
    }

    public static class BooleanPropertyConverter
    implements PropertyConverter {
        @Override
        public Object valueFromString(String param) {
            if (param == null) {
                return Boolean.TRUE;
            }
            return Boolean.valueOf(param);
        }

        @Override
        public String stringFromValue(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static class FloatPropertyConverter
    implements PropertyConverter {
        @Override
        public Object valueFromString(String param) {
            if (param == null) {
                return null;
            }
            return Float.valueOf(param);
        }

        @Override
        public String stringFromValue(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static class LongPropertyConverter
    implements PropertyConverter {
        @Override
        public Object valueFromString(String param) {
            if (param == null) {
                return null;
            }
            return Long.valueOf(param);
        }

        @Override
        public String stringFromValue(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static class IntegerPropertyConverter
    implements PropertyConverter {
        @Override
        public Object valueFromString(String param) {
            if (param == null) {
                return null;
            }
            return Integer.valueOf(param);
        }

        @Override
        public String stringFromValue(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static class StringPropertyConverter
    implements PropertyConverter {
        @Override
        public Object valueFromString(String param) {
            return param;
        }

        @Override
        public String stringFromValue(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static interface PropertyConverter {
        public Object valueFromString(String var1);

        public String stringFromValue(Object var1);
    }
}

