/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart;

import com.emc.rest.smart.Host;
import com.emc.rest.smart.HostListProvider;
import com.emc.rest.smart.LoadBalancer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SmartConfig {
    public static final int DEFAULT_POLL_INTERVAL = 120;
    private URI proxyUri;
    private String proxyUser;
    private String proxyPass;
    private final LoadBalancer loadBalancer;
    private HostListProvider hostListProvider;
    private int pollInterval = 120;
    private boolean hostUpdateEnabled = true;
    private boolean healthCheckEnabled = true;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public SmartConfig(String ... initialHostNames) {
        ArrayList<Host> hostList = new ArrayList<Host>();
        for (String hostName : initialHostNames) {
            hostList.add(new Host(hostName));
        }
        this.loadBalancer = new LoadBalancer(hostList);
    }

    public SmartConfig(List<Host> initialHosts) {
        this(new LoadBalancer(initialHosts));
    }

    public SmartConfig(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public synchronized LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public URI getProxyUri() {
        return this.proxyUri;
    }

    public void setProxyUri(URI proxyUri) {
        this.proxyUri = proxyUri;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public synchronized HostListProvider getHostListProvider() {
        return this.hostListProvider;
    }

    public synchronized void setHostListProvider(HostListProvider hostListProvider) {
        this.hostListProvider = hostListProvider;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public boolean isHostUpdateEnabled() {
        return this.hostUpdateEnabled;
    }

    public void setHostUpdateEnabled(boolean hostUpdateEnabled) {
        this.hostUpdateEnabled = hostUpdateEnabled;
    }

    public boolean isHealthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public void setHealthCheckEnabled(boolean healthCheckEnabled) {
        this.healthCheckEnabled = healthCheckEnabled;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String propName) {
        return this.properties.get(propName);
    }

    public void setProperty(String propName, Object value) {
        this.properties.put(propName, value);
    }

    public SmartConfig withProxyUri(URI proxyUri) {
        this.setProxyUri(proxyUri);
        return this;
    }

    public SmartConfig withProxyUser(String proxyUser) {
        this.setProxyUser(proxyUser);
        return this;
    }

    public SmartConfig withProxyPass(String proxyPass) {
        this.setProxyPass(proxyPass);
        return this;
    }

    public SmartConfig withHostListProvider(HostListProvider hostListProvider) {
        this.setHostListProvider(hostListProvider);
        return this;
    }

    public SmartConfig withPollInterval(int pollInterval) {
        this.setPollInterval(pollInterval);
        return this;
    }

    public SmartConfig withHostUpdateEnabled(boolean hostUpdateEnabled) {
        this.setHostUpdateEnabled(hostUpdateEnabled);
        return this;
    }

    public SmartConfig withHealthCheckEnabled(boolean healthCheckEnabled) {
        this.setHealthCheckEnabled(healthCheckEnabled);
        return this;
    }

    public SmartConfig withProperty(String propName, Object value) {
        this.setProperty(propName, value);
        return this;
    }
}

