/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.util;

import java.io.IOException;
import java.io.InputStream;

public class SizedInputStream
extends InputStream {
    private final InputStream source;
    private final long size;
    private long read = 0L;

    public SizedInputStream(InputStream source, long size) {
        this.source = source;
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public long getRead() {
        return this.read;
    }

    @Override
    public int read() throws IOException {
        byte[] single = new byte[1];
        return this.read(single) == -1 ? -1 : single[0] & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int count;
        long remaining = this.remaining();
        if (remaining <= 0L) {
            return -1;
        }
        if ((long)len > remaining) {
            len = (int)remaining;
        }
        if ((count = this.source.read(bytes, off, len)) != -1) {
            this.read += (long)count;
        }
        return count;
    }

    @Override
    public long skip(long len) throws IOException {
        long count;
        long remaining = this.remaining();
        if (remaining <= 0L) {
            return -1L;
        }
        if (len > remaining) {
            len = remaining;
        }
        if ((count = this.source.skip(len)) != -1L) {
            this.read += count;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        int available = this.source.available();
        return (long)available > this.remaining() ? (int)this.remaining() : available;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public void mark(int i) {
        this.source.mark(i);
    }

    @Override
    public void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }

    protected long remaining() {
        return this.size - this.read;
    }
}

