/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object;

import com.emc.object.EncryptionConfig;
import com.emc.object.Protocol;
import com.emc.object.util.ConfigUri;
import com.emc.object.util.ConfigUriProperty;
import com.emc.object.util.RestUtil;
import com.emc.rest.smart.Host;
import com.emc.rest.smart.SmartConfig;
import com.emc.rest.smart.ecs.Vdc;
import com.emc.rest.smart.ecs.VdcHost;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectConfig<T extends ObjectConfig<T>> {
    private static final Logger log = LoggerFactory.getLogger(ObjectConfig.class);
    public static final String PROPERTY_POLL_PROTOCOL = "com.emc.object.pollProtocol";
    public static final String PROPERTY_POLL_PORT = "com.emc.object.pollPort";
    public static final String PROPERTY_POLL_INTERVAL = "com.emc.object.pollInterval";
    public static final String PROPERTY_DISABLE_HEALTH_CHECK = "com.emc.object.disableHealthCheck";
    public static final String PROPERTY_DISABLE_HOST_UPDATE = "com.emc.object.disableHostUpdate";
    public static final String PROPERTY_PROXY_URI = "com.emc.object.proxyUri";
    public static final String PROPERTY_PROXY_USER = "com.emc.object.proxyUser";
    public static final String PROPERTY_PROXY_PASS = "com.emc.object.proxyPass";
    public static final String PACKAGE_VERSION = ObjectConfig.class.getPackage().getImplementationVersion();
    public static final String DEFAULT_USER_AGENT = String.format("ECS Java SDK%s Java/%s (%s; %s; %s)", PACKAGE_VERSION != null ? " v" + PACKAGE_VERSION : "", System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    public static final int DEFAULT_CHUNKED_ENCODING_SIZE = 0x200000;
    private Protocol protocol;
    private List<Vdc> vdcs;
    private int port = -1;
    private boolean smartClient = true;
    private String rootContext;
    private String namespace;
    private String identity;
    private String secretKey;
    private long serverClockSkew;
    private String userAgent = DEFAULT_USER_AGENT;
    private boolean geoPinningEnabled = false;
    private boolean geoReadRetryFailover = false;
    private int chunkedEncodingSize = 0x200000;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public ObjectConfig() {
    }

    public ObjectConfig(URI endpoint) {
        this(Protocol.valueOf(endpoint.getScheme().toUpperCase()), endpoint.getPort(), endpoint.getHost());
        this.setRootContext(endpoint.getPath());
        this.setSmartClient(false);
    }

    public ObjectConfig(Protocol protocol, int port, String ... hosts) {
        this(protocol, port, new Vdc(hosts));
    }

    public ObjectConfig(Protocol protocol, int port, Vdc ... vdcs) {
        this.protocol = protocol;
        this.port = port;
        this.vdcs = Arrays.asList(vdcs);
    }

    public ObjectConfig(ObjectConfig<T> other) {
        this.protocol = other.protocol;
        this.vdcs = new ArrayList<Vdc>();
        for (Vdc vdc : other.getVdcs()) {
            this.vdcs.add(new Vdc(vdc.getName(), vdc.getHosts()));
        }
        this.port = other.port;
        this.smartClient = other.smartClient;
        this.rootContext = other.rootContext;
        this.namespace = other.namespace;
        this.identity = other.identity;
        this.secretKey = other.secretKey;
        this.serverClockSkew = other.serverClockSkew;
        this.userAgent = other.userAgent;
        this.geoPinningEnabled = other.geoPinningEnabled;
        this.geoReadRetryFailover = other.geoReadRetryFailover;
        this.chunkedEncodingSize = other.chunkedEncodingSize;
        this.properties = new HashMap<String, Object>(other.properties);
    }

    public abstract Host resolveHost();

    public URI resolvePath(String subPath, String rawQuery) {
        String path = "";
        if (this.rootContext != null && this.rootContext.length() > 0) {
            path = path + this.rootContext;
        }
        if ((path = path + subPath).isEmpty()) {
            path = "/";
        }
        try {
            URI uri = RestUtil.buildUri(this.protocol.toString().toLowerCase(), this.resolveHost().getName(), this.port, path, rawQuery, null);
            log.debug("raw path & query: " + path + "?" + rawQuery);
            log.debug("resolved URI: " + uri);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI syntax", e);
        }
    }

    public SmartConfig toSmartConfig() {
        ArrayList allHosts = new ArrayList();
        for (Vdc vdc : this.vdcs) {
            allHosts.addAll(vdc.getHosts());
        }
        SmartConfig smartConfig = new SmartConfig(allHosts);
        if (!this.smartClient || Boolean.parseBoolean(this.propAsString(this.properties, PROPERTY_DISABLE_HEALTH_CHECK))) {
            smartConfig.setHealthCheckEnabled(false);
        }
        if (!this.smartClient || Boolean.parseBoolean(this.propAsString(this.properties, PROPERTY_DISABLE_HOST_UPDATE))) {
            smartConfig.setHostUpdateEnabled(false);
        }
        if (this.properties.containsKey(PROPERTY_POLL_INTERVAL)) {
            try {
                smartConfig.setPollInterval(Integer.parseInt(this.propAsString(this.properties, PROPERTY_POLL_INTERVAL)));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(String.format("invalid poll interval (%s=%s)", PROPERTY_POLL_INTERVAL, this.properties.get(PROPERTY_POLL_INTERVAL)), e);
            }
        }
        try {
            if (this.properties.containsKey(PROPERTY_PROXY_URI)) {
                smartConfig.setProxyUri(new URI(this.getPropAsString(PROPERTY_PROXY_URI)));
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid proxy URI", e);
        }
        smartConfig.setProxyUser(this.getPropAsString(PROPERTY_PROXY_USER));
        smartConfig.setProxyPass(this.getPropAsString(PROPERTY_PROXY_PASS));
        for (String prop : this.properties.keySet()) {
            smartConfig.withProperty(prop, this.properties.get(prop));
        }
        return smartConfig;
    }

    protected String propAsString(Map<String, Object> properties, String propName) {
        Object value = properties.get(propName);
        return value == null ? null : value.toString();
    }

    @ConfigUriProperty(type=ConfigUriProperty.Type.Protocol, converter=ProtocolConverter.class)
    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @ConfigUriProperty(converter=VdcConverter.class)
    public List<Vdc> getVdcs() {
        return this.vdcs;
    }

    public void setVdcs(List<Vdc> vdcs) {
        this.vdcs = vdcs;
    }

    @ConfigUriProperty(type=ConfigUriProperty.Type.Host)
    public String getHost() {
        if (this.getVdcs() == null || this.getVdcs().isEmpty()) {
            return null;
        }
        return ((VdcHost)this.getVdcs().get(0).getHosts().get(0)).getName();
    }

    public void setHost(String host) {
        this.setVdcs(Collections.singletonList(new Vdc(new String[]{host})));
    }

    @ConfigUriProperty(type=ConfigUriProperty.Type.Port)
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ConfigUriProperty
    public boolean isSmartClient() {
        return this.smartClient;
    }

    public void setSmartClient(boolean smartClient) {
        this.smartClient = smartClient;
    }

    @ConfigUriProperty(type=ConfigUriProperty.Type.Path)
    public String getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(String rootContext) {
        if (rootContext != null && (rootContext = rootContext.trim().replaceAll("^/", "").replaceAll("/$", "")).length() > 0) {
            rootContext = "/" + rootContext;
        }
        this.rootContext = rootContext;
    }

    @ConfigUriProperty
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @ConfigUriProperty
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @ConfigUriProperty
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @ConfigUriProperty
    public long getServerClockSkew() {
        return this.serverClockSkew;
    }

    public void setServerClockSkew(long serverClockSkew) {
        this.serverClockSkew = serverClockSkew;
    }

    @ConfigUriProperty
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public EncryptionConfig getEncryptionConfig() {
        return null;
    }

    public void setEncryptionConfig(EncryptionConfig encryptionConfig) {
    }

    @ConfigUriProperty
    public boolean isGeoPinningEnabled() {
        return this.geoPinningEnabled;
    }

    public void setGeoPinningEnabled(boolean geoPinningEnabled) {
        this.geoPinningEnabled = geoPinningEnabled;
    }

    @ConfigUriProperty
    public boolean isGeoReadRetryFailover() {
        return this.geoReadRetryFailover;
    }

    public void setGeoReadRetryFailover(boolean geoReadRetryFailover) {
        this.geoReadRetryFailover = geoReadRetryFailover;
    }

    @ConfigUriProperty
    public int getChunkedEncodingSize() {
        return this.chunkedEncodingSize;
    }

    public void setChunkedEncodingSize(int chunkedEncodingSize) {
        this.chunkedEncodingSize = chunkedEncodingSize;
    }

    @ConfigUriProperty(converter=ConfigUri.StringPropertyConverter.class)
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String propName) {
        return this.properties.get(propName);
    }

    public String getPropAsString(String propName) {
        Object value = this.getProperty(propName);
        return value == null ? null : value.toString();
    }

    public void setProperty(String propName, Object value) {
        this.properties.put(propName, value);
    }

    public T withPort(int port) {
        this.setPort(port);
        return (T)this;
    }

    public T withSmartClient(boolean smartClient) {
        this.setSmartClient(smartClient);
        return (T)this;
    }

    public T withRootContext(String rootContext) {
        this.setRootContext(rootContext);
        return (T)this;
    }

    public T withNamespace(String namespace) {
        this.setNamespace(namespace);
        return (T)this;
    }

    public T withIdentity(String identity) {
        this.setIdentity(identity);
        return (T)this;
    }

    public T withSecretKey(String secretKey) {
        this.setSecretKey(secretKey);
        return (T)this;
    }

    public T withUserAgent(String userAgent) {
        this.setUserAgent(userAgent);
        return (T)this;
    }

    public T withEncryptionConfig(EncryptionConfig encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return (T)this;
    }

    public T withGeoPinningEnabled(boolean geoPinningEnabled) {
        this.setGeoPinningEnabled(geoPinningEnabled);
        return (T)this;
    }

    public T withChunkedEncodingSize(int chunkedEncodingSize) {
        this.setChunkedEncodingSize(chunkedEncodingSize);
        return (T)this;
    }

    public T withProperty(String propName, Object value) {
        this.setProperty(propName, value);
        return (T)this;
    }

    public String toString() {
        return "ObjectConfig{protocol=" + (Object)((Object)this.protocol) + ", vdcs=" + this.vdcs + ", port=" + this.port + ", smartClient=" + this.smartClient + ", rootContext='" + this.rootContext + '\'' + ", namespace='" + this.namespace + '\'' + ", identity='" + this.identity + '\'' + ", secretKey='" + this.secretKey + '\'' + ", serverClockSkew=" + this.serverClockSkew + ", userAgent='" + this.userAgent + '\'' + ", geoPinningEnabled=" + this.geoPinningEnabled + ", geoReadRetryFailover=" + this.geoReadRetryFailover + ", properties=" + this.properties + '}';
    }

    public static class VdcConverter
    implements ConfigUri.PropertyConverter {
        @Override
        public Object valueFromString(String param) {
            if (param == null) {
                return null;
            }
            return new Vdc(param.split(","));
        }

        @Override
        public String stringFromValue(Object value) {
            if (value == null) {
                return null;
            }
            Vdc vdc = (Vdc)value;
            StringBuilder stringBuilder = new StringBuilder();
            String separator = "";
            for (Host host : vdc.getHosts()) {
                stringBuilder.append(separator).append(host.getName());
                separator = ",";
            }
            return stringBuilder.toString();
        }
    }

    public static class ProtocolConverter
    implements ConfigUri.PropertyConverter {
        @Override
        public Object valueFromString(String param) {
            if (param == null) {
                return null;
            }
            return Protocol.valueOf(param.toUpperCase());
        }

        @Override
        public String stringFromValue(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString().toLowerCase();
        }
    }
}

