/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CopyObjectRequest
extends S3ObjectRequest {
    private String sourceBucketName;
    private String sourceKey;
    private String sourceVersionId;
    private Date ifSourceModifiedSince;
    private Date ifSourceUnmodifiedSince;
    private String ifSourceMatch;
    private String ifSourceNoneMatch;
    private String ifTargetMatch;
    private String ifTargetNoneMatch;
    private S3ObjectMetadata objectMetadata;
    private AccessControlList acl;
    private CannedAcl cannedAcl;

    public CopyObjectRequest(String sourceBucketName, String sourceKey, String bucketName, String key) {
        super(Method.PUT, bucketName, key, null);
        this.sourceBucketName = sourceBucketName;
        this.sourceKey = sourceKey;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        String source = String.format("/%s/%s", RestUtil.urlEncode(this.sourceBucketName), RestUtil.urlEncode(this.sourceKey));
        if (this.sourceVersionId != null) {
            source = source + "?versionId=" + this.sourceVersionId;
        }
        RestUtil.putSingle(headers, "x-amz-copy-source", source);
        if (this.ifSourceModifiedSince != null) {
            RestUtil.putSingle(headers, "x-amz-copy-source-if-modified-since", this.ifSourceModifiedSince);
        }
        if (this.ifSourceUnmodifiedSince != null) {
            RestUtil.putSingle(headers, "x-amz-copy-source-if-unmodified-since", this.ifSourceUnmodifiedSince);
        }
        if (this.ifSourceMatch != null) {
            RestUtil.putSingle(headers, "x-amz-copy-source-if-match", this.ifSourceMatch);
        }
        if (this.ifSourceNoneMatch != null) {
            RestUtil.putSingle(headers, "x-amz-copy-source-if-none-match", this.ifSourceNoneMatch);
        }
        if (this.ifTargetMatch != null) {
            RestUtil.putSingle(headers, "If-Match", this.ifTargetMatch);
        }
        if (this.ifTargetNoneMatch != null) {
            RestUtil.putSingle(headers, "If-None-Match", this.ifTargetNoneMatch);
        }
        if (this.objectMetadata != null) {
            RestUtil.putSingle(headers, "x-amz-metadata-directive", "REPLACE");
            headers.putAll(this.objectMetadata.toHeaders());
        }
        if (this.acl != null) {
            headers.putAll(this.acl.toHeaders());
        }
        if (this.cannedAcl != null) {
            RestUtil.putSingle(headers, "x-amz-acl", this.cannedAcl.getHeaderValue());
        }
        return headers;
    }

    public String getSourceBucketName() {
        return this.sourceBucketName;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getSourceVersionId() {
        return this.sourceVersionId;
    }

    public void setSourceVersionId(String sourceVersionId) {
        this.sourceVersionId = sourceVersionId;
    }

    public Date getIfSourceModifiedSince() {
        return this.ifSourceModifiedSince;
    }

    public void setIfSourceModifiedSince(Date ifSourceModifiedSince) {
        this.ifSourceModifiedSince = ifSourceModifiedSince;
    }

    public Date getIfSourceUnmodifiedSince() {
        return this.ifSourceUnmodifiedSince;
    }

    public void setIfSourceUnmodifiedSince(Date ifSourceUnmodifiedSince) {
        this.ifSourceUnmodifiedSince = ifSourceUnmodifiedSince;
    }

    public String getIfSourceMatch() {
        return this.ifSourceMatch;
    }

    public void setIfSourceMatch(String ifSourceMatch) {
        this.ifSourceMatch = ifSourceMatch;
    }

    public String getIfSourceNoneMatch() {
        return this.ifSourceNoneMatch;
    }

    public void setIfSourceNoneMatch(String ifSourceNoneMatch) {
        this.ifSourceNoneMatch = ifSourceNoneMatch;
    }

    public String getIfTargetMatch() {
        return this.ifTargetMatch;
    }

    public void setIfTargetMatch(String ifTargetMatch) {
        this.ifTargetMatch = ifTargetMatch;
    }

    public String getIfTargetNoneMatch() {
        return this.ifTargetNoneMatch;
    }

    public void setIfTargetNoneMatch(String ifTargetNoneMatch) {
        this.ifTargetNoneMatch = ifTargetNoneMatch;
    }

    public S3ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAcl cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public CopyObjectRequest withSourceVersionId(String sourceVersionId) {
        this.setSourceVersionId(sourceVersionId);
        return this;
    }

    public CopyObjectRequest withIfModifiedSince(Date ifModifiedSince) {
        this.setIfSourceModifiedSince(ifModifiedSince);
        return this;
    }

    public CopyObjectRequest withIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.setIfSourceUnmodifiedSince(ifUnmodifiedSince);
        return this;
    }

    public CopyObjectRequest withIfMatch(String ifMatch) {
        this.setIfSourceMatch(ifMatch);
        return this;
    }

    public CopyObjectRequest withIfNoneMatch(String ifNoneMatch) {
        this.setIfSourceNoneMatch(ifNoneMatch);
        return this;
    }

    public CopyObjectRequest withObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public CopyObjectRequest withAcl(AccessControlList acl) {
        this.setAcl(acl);
        return this;
    }

    public CopyObjectRequest withCannedAcl(CannedAcl cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }
}

