/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Range;
import com.emc.object.s3.request.CopyObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.List;
import java.util.Map;

public class CopyPartRequest
extends CopyObjectRequest {
    private String uploadId;
    private int partNumber;
    private Range sourceRange;

    public CopyPartRequest(String sourceBucketName, String sourceKey, String bucketName, String key, String uploadId, int partNumber) {
        super(sourceBucketName, sourceKey, bucketName, key);
        this.uploadId = uploadId;
        this.partNumber = partNumber;
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        queryParams.put("uploadId", this.uploadId);
        queryParams.put("partNumber", Integer.toString(this.partNumber));
        return queryParams;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.sourceRange != null) {
            RestUtil.putSingle(headers, "x-amz-copy-source-range", "bytes=" + this.sourceRange);
        }
        return headers;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public Range getSourceRange() {
        return this.sourceRange;
    }

    public void setSourceRange(Range sourceRange) {
        this.sourceRange = sourceRange;
    }

    public CopyPartRequest withSourceRange(Range sourceRange) {
        this.setSourceRange(sourceRange);
        return this;
    }
}

