/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.s3.request.UploadPartRequest;
import com.emc.object.util.InputStreamSegment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class UploadFilePartRequest
extends UploadPartRequest {
    private File file;
    private long offset = -1L;
    private long length;

    public UploadFilePartRequest(String bucketName, String key, String uploadId, int partNumber) {
        super(bucketName, key, uploadId, partNumber, null);
    }

    @Override
    public Object getEntity() {
        try {
            return new InputStreamSegment(new FileInputStream(this.file), this.offset, this.length);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("bad file parameters", e);
        }
    }

    @Override
    public Long getContentLength() {
        return this.length;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public UploadFilePartRequest withFile(File file) {
        this.setFile(file);
        return this;
    }

    public UploadFilePartRequest withOffset(long offset) {
        this.setOffset(offset);
        return this;
    }

    public UploadFilePartRequest withLength(long length) {
        this.setLength(length);
        return this;
    }
}

