/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.AbstractJerseyClient;
import com.emc.object.Method;
import com.emc.object.ObjectRequest;
import com.emc.object.Protocol;
import com.emc.object.Range;
import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Exception;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.S3SignerV2;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.BucketInfo;
import com.emc.object.s3.bean.BucketPolicy;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.bean.CompleteMultipartUploadResult;
import com.emc.object.s3.bean.CopyObjectResult;
import com.emc.object.s3.bean.CopyPartResult;
import com.emc.object.s3.bean.CorsConfiguration;
import com.emc.object.s3.bean.DeleteObjectsResult;
import com.emc.object.s3.bean.GetObjectResult;
import com.emc.object.s3.bean.InitiateMultipartUploadResult;
import com.emc.object.s3.bean.LifecycleConfiguration;
import com.emc.object.s3.bean.ListBucketsResult;
import com.emc.object.s3.bean.ListDataNode;
import com.emc.object.s3.bean.ListMultipartUploadsResult;
import com.emc.object.s3.bean.ListObjectsResult;
import com.emc.object.s3.bean.ListPartsResult;
import com.emc.object.s3.bean.ListVersionsResult;
import com.emc.object.s3.bean.LocationConstraint;
import com.emc.object.s3.bean.MetadataSearchList;
import com.emc.object.s3.bean.MultipartPartETag;
import com.emc.object.s3.bean.ObjectLockConfiguration;
import com.emc.object.s3.bean.ObjectLockLegalHold;
import com.emc.object.s3.bean.ObjectLockRetention;
import com.emc.object.s3.bean.PingResponse;
import com.emc.object.s3.bean.PutObjectResult;
import com.emc.object.s3.bean.QueryObjectsResult;
import com.emc.object.s3.bean.VersioningConfiguration;
import com.emc.object.s3.jersey.AuthorizationFilter;
import com.emc.object.s3.jersey.BucketFilter;
import com.emc.object.s3.jersey.ChecksumFilter;
import com.emc.object.s3.jersey.ErrorFilter;
import com.emc.object.s3.jersey.FaultInjectionFilter;
import com.emc.object.s3.jersey.GeoPinningFilter;
import com.emc.object.s3.jersey.GeoPinningRule;
import com.emc.object.s3.jersey.NamespaceFilter;
import com.emc.object.s3.jersey.RetryFilter;
import com.emc.object.s3.request.AbortMultipartUploadRequest;
import com.emc.object.s3.request.CompleteMultipartUploadRequest;
import com.emc.object.s3.request.CopyObjectRequest;
import com.emc.object.s3.request.CopyPartRequest;
import com.emc.object.s3.request.CreateBucketRequest;
import com.emc.object.s3.request.DeleteObjectsRequest;
import com.emc.object.s3.request.GenericBucketEntityRequest;
import com.emc.object.s3.request.GenericBucketRequest;
import com.emc.object.s3.request.GetObjectAclRequest;
import com.emc.object.s3.request.GetObjectLegalHoldRequest;
import com.emc.object.s3.request.GetObjectMetadataRequest;
import com.emc.object.s3.request.GetObjectRequest;
import com.emc.object.s3.request.GetObjectRetentionRequest;
import com.emc.object.s3.request.InitiateMultipartUploadRequest;
import com.emc.object.s3.request.ListBucketsRequest;
import com.emc.object.s3.request.ListMultipartUploadsRequest;
import com.emc.object.s3.request.ListObjectsRequest;
import com.emc.object.s3.request.ListPartsRequest;
import com.emc.object.s3.request.ListVersionsRequest;
import com.emc.object.s3.request.PresignedUrlRequest;
import com.emc.object.s3.request.PutObjectRequest;
import com.emc.object.s3.request.QueryObjectsRequest;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.s3.request.SetBucketAclRequest;
import com.emc.object.s3.request.SetObjectAclRequest;
import com.emc.object.s3.request.SetObjectLegalHoldRequest;
import com.emc.object.s3.request.SetObjectRetentionRequest;
import com.emc.object.s3.request.UploadPartRequest;
import com.emc.object.util.RestUtil;
import com.emc.rest.smart.HostListProvider;
import com.emc.rest.smart.HostVetoRule;
import com.emc.rest.smart.LoadBalancer;
import com.emc.rest.smart.SmartClientFactory;
import com.emc.rest.smart.SmartConfig;
import com.emc.rest.smart.ecs.EcsHostListProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class S3JerseyClient
extends AbstractJerseyClient
implements S3Client {
    protected S3Config s3Config = (S3Config)super.getObjectConfig();
    protected Client client;
    protected LoadBalancer loadBalancer;
    protected S3SignerV2 signer = new S3SignerV2(this.s3Config);

    public S3JerseyClient(S3Config s3Config) {
        this(s3Config, null);
    }

    public S3JerseyClient(S3Config config, ClientHandler clientHandler) {
        super(new S3Config(config));
        SmartConfig smartConfig = this.s3Config.toSmartConfig();
        this.loadBalancer = smartConfig.getLoadBalancer();
        smartConfig.setProperty("com.sun.jersey.client.property.chunkedEncodingSize", (Object)this.s3Config.getChunkedEncodingSize());
        this.client = clientHandler == null ? SmartClientFactory.createStandardClient((SmartConfig)smartConfig) : SmartClientFactory.createStandardClient((SmartConfig)smartConfig, (ClientHandler)clientHandler);
        if (this.s3Config.isSmartClient()) {
            EcsHostListProvider hostListProvider = new EcsHostListProvider(this.client, this.loadBalancer, this.s3Config.getIdentity(), this.s3Config.getSecretKey());
            smartConfig.setHostListProvider((HostListProvider)hostListProvider);
            if (this.s3Config.getProperty("com.emc.object.pollProtocol") != null) {
                hostListProvider.setProtocol(this.s3Config.getPropAsString("com.emc.object.pollProtocol"));
            } else {
                hostListProvider.setProtocol(this.s3Config.getProtocol().toString());
            }
            if (this.s3Config.getProperty("com.emc.object.pollPort") != null) {
                try {
                    hostListProvider.setPort(Integer.parseInt(this.s3Config.getPropAsString("com.emc.object.pollPort")));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(String.format("invalid poll port (%s=%s)", "com.emc.object.pollPort", this.s3Config.getPropAsString("com.emc.object.pollPort")), e);
                }
            } else {
                hostListProvider.setPort(this.s3Config.getPort());
            }
            hostListProvider.setVdcs(this.s3Config.getVdcs());
            if (this.s3Config.isGeoPinningEnabled()) {
                this.loadBalancer.withVetoRules(new HostVetoRule[]{new GeoPinningRule()});
            }
            this.client = clientHandler == null ? SmartClientFactory.createSmartClient((SmartConfig)smartConfig) : SmartClientFactory.createSmartClient((SmartConfig)smartConfig, (ClientHandler)clientHandler);
        }
        this.client.addFilter((ClientFilter)new ErrorFilter());
        if (this.s3Config.getFaultInjectionRate() > 0.0f) {
            this.client.addFilter((ClientFilter)new FaultInjectionFilter(this.s3Config.getFaultInjectionRate()));
        }
        if (this.s3Config.isGeoPinningEnabled()) {
            this.client.addFilter((ClientFilter)new GeoPinningFilter(this.s3Config));
        }
        if (this.s3Config.isRetryEnabled()) {
            this.client.addFilter((ClientFilter)new RetryFilter(this.s3Config));
        }
        if (this.s3Config.isChecksumEnabled()) {
            this.client.addFilter((ClientFilter)new ChecksumFilter(this.s3Config));
        }
        this.client.addFilter((ClientFilter)new AuthorizationFilter(this.s3Config));
        this.client.addFilter((ClientFilter)new BucketFilter(this.s3Config));
        this.client.addFilter((ClientFilter)new NamespaceFilter(this.s3Config));
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void shutdown() {
        this.destroy();
    }

    @Override
    public void destroy() {
        SmartClientFactory.destroy((Client)this.client);
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    @Override
    public ListDataNode listDataNodes() {
        return this.executeRequest(this.client, new ObjectRequest(Method.GET, "", "endpoint"), ListDataNode.class);
    }

    @Override
    public PingResponse pingNode(String host) {
        return this.pingNode(this.s3Config.getProtocol(), host, this.s3Config.getPort());
    }

    @Override
    public PingResponse pingNode(Protocol protocol, String host, int port) {
        String portStr = port > 0 ? ":" + port : "";
        WebResource resource = this.client.resource(String.format("%s://%s%s/?ping", protocol.name().toLowerCase(), host, portStr));
        resource.setProperty("com.emc.rest.smart.bypassLoadBalancer", (Object)true);
        return (PingResponse)resource.get(PingResponse.class);
    }

    @Override
    public ListBucketsResult listBuckets() {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public ListBucketsResult listBuckets(ListBucketsRequest request) {
        return this.executeRequest(this.client, request, ListBucketsResult.class);
    }

    @Override
    public boolean bucketExists(String bucketName) {
        try {
            this.executeAndClose(this.client, new GenericBucketRequest(Method.HEAD, bucketName, null));
            return true;
        }
        catch (S3Exception e) {
            switch (e.getHttpCode()) {
                case 301: 
                case 403: {
                    return true;
                }
                case 404: {
                    return false;
                }
            }
            throw e;
        }
    }

    @Override
    public void createBucket(String bucketName) {
        this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public void createBucket(CreateBucketRequest request) {
        this.executeAndClose(this.client, request);
    }

    @Override
    public BucketInfo getBucketInfo(String bucketName) {
        BucketInfo result = new BucketInfo();
        result.setBucketName(bucketName);
        this.fillResponseEntity(result, this.executeAndClose(this.client, new GenericBucketRequest(Method.HEAD, bucketName, null)));
        return result;
    }

    @Override
    public void deleteBucket(String bucketName) {
        this.executeAndClose(this.client, new GenericBucketRequest(Method.DELETE, bucketName, null));
    }

    @Override
    public void setBucketAcl(String bucketName, AccessControlList acl) {
        this.setBucketAcl(new SetBucketAclRequest(bucketName).withAcl(acl));
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAcl cannedAcl) {
        this.setBucketAcl(new SetBucketAclRequest(bucketName).withCannedAcl(cannedAcl));
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest request) {
        this.executeAndClose(this.client, request);
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "acl");
        return this.executeRequest(this.client, request, AccessControlList.class);
    }

    @Override
    public void setBucketCors(String bucketName, CorsConfiguration corsConfiguration) {
        GenericBucketEntityRequest request = new GenericBucketEntityRequest<CorsConfiguration>(Method.PUT, bucketName, "cors", corsConfiguration).withContentType("application/xml");
        this.executeAndClose(this.client, request);
    }

    @Override
    public CorsConfiguration getBucketCors(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "cors");
        try {
            return this.executeRequest(this.client, request, CorsConfiguration.class);
        }
        catch (S3Exception e) {
            if ("NoSuchCORSConfiguration".equals(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void deleteBucketCors(String bucketName) {
        this.executeAndClose(this.client, new GenericBucketRequest(Method.DELETE, bucketName, "cors"));
    }

    @Override
    public void setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfiguration) {
        GenericBucketEntityRequest request = new GenericBucketEntityRequest<LifecycleConfiguration>(Method.PUT, bucketName, "lifecycle", lifecycleConfiguration).withContentType("application/xml");
        this.executeAndClose(this.client, request);
    }

    @Override
    public LifecycleConfiguration getBucketLifecycle(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "lifecycle");
        try {
            return this.executeRequest(this.client, request, LifecycleConfiguration.class);
        }
        catch (S3Exception e) {
            if ("NoSuchBucketPolicy".equals(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void deleteBucketLifecycle(String bucketName) {
        this.executeAndClose(this.client, new GenericBucketRequest(Method.DELETE, bucketName, "lifecycle"));
    }

    @Override
    public void setBucketPolicy(String bucketName, BucketPolicy policy) {
        GenericBucketEntityRequest request = new GenericBucketEntityRequest<BucketPolicy>(Method.PUT, bucketName, "policy", policy).withContentType("application/json");
        this.executeAndClose(this.client, request);
    }

    @Override
    public BucketPolicy getBucketPolicy(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "policy");
        return this.executeRequest(this.client, request, BucketPolicy.class);
    }

    @Override
    public LocationConstraint getBucketLocation(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "location");
        return this.executeRequest(this.client, request, LocationConstraint.class);
    }

    @Override
    public void setBucketVersioning(String bucketName, VersioningConfiguration versioningConfiguration) {
        GenericBucketEntityRequest request = new GenericBucketEntityRequest<VersioningConfiguration>(Method.PUT, bucketName, "versioning", versioningConfiguration).withContentType("application/xml");
        this.executeAndClose(this.client, request);
    }

    @Override
    public VersioningConfiguration getBucketVersioning(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "versioning");
        return this.executeRequest(this.client, request, VersioningConfiguration.class);
    }

    @Override
    public void setBucketStaleReadAllowed(String bucketName, final boolean staleReadAllowed) {
        GenericBucketRequest request = new GenericBucketRequest(Method.PUT, bucketName, "isstaleallowed"){

            @Override
            public Map<String, List<Object>> getHeaders() {
                Map<String, List<Object>> headers = super.getHeaders();
                RestUtil.putSingle(headers, "x-emc-is-stale-allowed", staleReadAllowed);
                return headers;
            }
        };
        this.executeAndClose(this.client, request);
    }

    @Override
    public MetadataSearchList listSystemMetadataSearchKeys() {
        ObjectRequest request = new ObjectRequest(Method.GET, "", "searchmetadata");
        return this.executeRequest(this.client, request, MetadataSearchList.class);
    }

    @Override
    public MetadataSearchList listBucketMetadataSearchKeys(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "searchmetadata");
        return this.executeRequest(this.client, request, MetadataSearchList.class);
    }

    @Override
    public QueryObjectsResult queryObjects(QueryObjectsRequest request) {
        String query = request.getQuery();
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException("QueryObjectsRequest must contain a query expression.");
        }
        QueryObjectsResult result = this.executeRequest(this.client, request, QueryObjectsResult.class);
        result.setQuery(query);
        result.setAttributes(request.getAttributes());
        result.setSorted(request.getSorted());
        result.setIncludeOlderVersions(request.getIncludeOlderVersions());
        return result;
    }

    @Override
    public QueryObjectsResult queryMoreObjects(QueryObjectsResult lastResult) {
        return this.queryObjects(new QueryObjectsRequest(lastResult.getBucketName()).withQuery(lastResult.getQuery()).withAttributes(lastResult.getAttributes()).withSorted(lastResult.getSorted()).withIncludeOlderVersions(lastResult.getIncludeOlderVersions()).withMaxKeys(lastResult.getMaxKeys()).withMarker(lastResult.getNextMarker()));
    }

    @Override
    public ListObjectsResult listObjects(String bucketName) {
        return this.listObjects(new ListObjectsRequest(bucketName));
    }

    @Override
    public ListObjectsResult listObjects(String bucketName, String prefix) {
        return this.listObjects(new ListObjectsRequest(bucketName).withPrefix(prefix));
    }

    @Override
    public ListObjectsResult listObjects(ListObjectsRequest request) {
        ListObjectsResult result = this.executeRequest(this.client, request, ListObjectsResult.class);
        if (result.isTruncated() && result.getNextMarker() == null) {
            result.setNextMarker(result.getObjects().get(result.getObjects().size() - 1).getKey());
        }
        return result;
    }

    @Override
    public ListObjectsResult listMoreObjects(ListObjectsResult lastResult) {
        return this.listObjects(new ListObjectsRequest(lastResult.getBucketName()).withPrefix(lastResult.getPrefix()).withDelimiter(lastResult.getDelimiter()).withEncodingType(lastResult.getEncodingType()).withMaxKeys(lastResult.getMaxKeys()).withMarker(lastResult.getNextMarker()));
    }

    @Override
    public ListVersionsResult listVersions(String bucketName, String prefix) {
        return this.listVersions(new ListVersionsRequest(bucketName).withPrefix(prefix));
    }

    @Override
    public ListVersionsResult listVersions(ListVersionsRequest request) {
        return this.executeRequest(this.client, request, ListVersionsResult.class);
    }

    @Override
    public ListVersionsResult listMoreVersions(ListVersionsResult lastResult) {
        return this.listVersions(new ListVersionsRequest(lastResult.getBucketName()).withPrefix(lastResult.getPrefix()).withDelimiter(lastResult.getDelimiter()).withEncodingType(lastResult.getEncodingType()).withMaxKeys(lastResult.getMaxKeys()).withKeyMarker(lastResult.getNextKeyMarker()).withVersionIdMarker(lastResult.getNextVersionIdMarker()));
    }

    @Override
    public void putObject(String bucketName, String key, Object content, String contentType) {
        S3ObjectMetadata metadata = new S3ObjectMetadata().withContentType(contentType);
        this.putObject(new PutObjectRequest(bucketName, key, content).withObjectMetadata(metadata));
    }

    @Override
    public void putObject(String bucketName, String key, Range range, Object content) {
        this.putObject(new PutObjectRequest(bucketName, key, content).withRange(range));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) {
        request.property("com.emc.object.verifyWriteChecksum", Boolean.TRUE);
        PutObjectResult result = new PutObjectResult();
        this.fillResponseEntity(result, this.executeAndClose(this.client, request));
        return result;
    }

    @Override
    public long appendObject(String bucketName, String key, Object content) {
        return this.putObject(new PutObjectRequest(bucketName, key, content).withRange(Range.fromOffset(-1L))).getAppendOffset();
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String bucketName, String key) {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, bucketName, key));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) {
        return this.executeRequest(this.client, request, CopyObjectResult.class);
    }

    @Override
    public <T> T readObject(String bucketName, String key, Class<T> objectType) {
        GetObjectResult<T> result = this.getObject(new GetObjectRequest(bucketName, key), objectType);
        return result == null ? null : (T)result.getObject();
    }

    @Override
    public <T> T readObject(String bucketName, String key, String versionId, Class<T> objectType) {
        GetObjectResult<T> result = this.getObject((GetObjectRequest)new GetObjectRequest(bucketName, key).withVersionId(versionId), objectType);
        return result == null ? null : (T)result.getObject();
    }

    @Override
    public InputStream readObjectStream(String bucketName, String key, Range range) {
        GetObjectResult<InputStream> result = this.getObject((GetObjectRequest)new GetObjectRequest(bucketName, key).withRange(range), (Class)InputStream.class);
        return result == null ? null : result.getObject();
    }

    @Override
    public GetObjectResult<InputStream> getObject(String bucketName, String key) {
        return this.getObject(new GetObjectRequest(bucketName, key), InputStream.class);
    }

    @Override
    public <T> GetObjectResult<T> getObject(GetObjectRequest request, Class<T> objectType) {
        try {
            if (request.getRange() == null) {
                request.property("com.emc.object.verifyReadChecksum", Boolean.TRUE);
            }
            GetObjectResult<Object> result = new GetObjectResult<Object>();
            ClientResponse response = this.executeRequest(this.client, request);
            this.fillResponseEntity(result, response);
            result.setObject(response.getEntity(objectType));
            return result;
        }
        catch (S3Exception e) {
            if (e.getHttpCode() == 304 || e.getHttpCode() == 412) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public URL getPresignedUrl(String bucketName, String key, Date expirationTime) {
        return this.getPresignedUrl(new PresignedUrlRequest(Method.GET, bucketName, key, expirationTime));
    }

    @Override
    public URL getPresignedUrl(PresignedUrlRequest request) {
        return this.signer.generatePresignedUrl(request);
    }

    @Override
    public void deleteObject(String bucketName, String key) {
        this.executeAndClose(this.client, new S3ObjectRequest(Method.DELETE, bucketName, key, null));
    }

    @Override
    public void deleteVersion(String bucketName, String key, String versionId) {
        this.executeAndClose(this.client, new S3ObjectRequest(Method.DELETE, bucketName, key, "versionId=" + versionId));
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest request) {
        return this.executeRequest(this.client, request, DeleteObjectsResult.class);
    }

    @Override
    public void setObjectMetadata(String bucketName, String key, S3ObjectMetadata objectMetadata) {
        AccessControlList acl = this.getObjectAcl(bucketName, key);
        this.copyObject(new CopyObjectRequest(bucketName, key, bucketName, key).withAcl(acl).withObjectMetadata(objectMetadata));
    }

    @Override
    public S3ObjectMetadata getObjectMetadata(String bucketName, String key) {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    @Override
    public S3ObjectMetadata getObjectMetadata(GetObjectMetadataRequest request) {
        try {
            return S3ObjectMetadata.fromHeaders(this.executeAndClose(this.client, request).getHeaders());
        }
        catch (S3Exception e) {
            if (e.getHttpCode() == 304 || e.getHttpCode() == 412) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void setObjectAcl(String bucketName, String key, AccessControlList acl) {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key).withAcl(acl));
    }

    @Override
    public void setObjectAcl(String bucketName, String key, CannedAcl cannedAcl) {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key).withCannedAcl(cannedAcl));
    }

    @Override
    public void setObjectAcl(SetObjectAclRequest request) {
        this.executeAndClose(this.client, request);
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key) {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, key));
    }

    @Override
    public AccessControlList getObjectAcl(GetObjectAclRequest request) {
        return this.executeRequest(this.client, request, AccessControlList.class);
    }

    @Override
    public void extendRetentionPeriod(String bucketName, String key, Long period) {
        S3ObjectRequest request = new S3ObjectRequest(Method.PUT, bucketName, key, "retentionUpdate");
        request.addCustomHeader("x-emc-retention-period", period);
        this.executeAndClose(this.client, request);
    }

    @Override
    public ListMultipartUploadsResult listMultipartUploads(String bucketName) {
        return this.listMultipartUploads(new ListMultipartUploadsRequest(bucketName));
    }

    @Override
    public ListMultipartUploadsResult listMultipartUploads(ListMultipartUploadsRequest request) {
        return this.executeRequest(this.client, request, ListMultipartUploadsResult.class);
    }

    @Override
    public String initiateMultipartUpload(String bucketName, String key) {
        return this.initiateMultipartUpload(new InitiateMultipartUploadRequest(bucketName, key)).getUploadId();
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) {
        return this.executeRequest(this.client, request, InitiateMultipartUploadResult.class);
    }

    @Override
    public ListPartsResult listParts(String bucketName, String key, String uploadId) {
        return this.listParts(new ListPartsRequest(bucketName, key, uploadId));
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) {
        return this.executeRequest(this.client, request, ListPartsResult.class);
    }

    @Override
    public MultipartPartETag uploadPart(UploadPartRequest request) {
        return new MultipartPartETag(request.getPartNumber(), this.executeAndClose(this.client, request).getEntityTag().getValue());
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest request) {
        CopyPartResult result = this.executeRequest(this.client, request, CopyPartResult.class);
        result.setPartNumber(request.getPartNumber());
        return result;
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) {
        return this.executeRequest(this.client, request, CompleteMultipartUploadResult.class);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest request) {
        this.executeAndClose(this.client, request);
    }

    @Override
    public void setObjectLockConfiguration(String bucketName, ObjectLockConfiguration objectLockConfiguration) {
        GenericBucketEntityRequest request = new GenericBucketEntityRequest<ObjectLockConfiguration>(Method.PUT, bucketName, "object-lock", objectLockConfiguration).withContentType("application/xml");
        this.executeAndClose(this.client, request);
    }

    @Override
    public ObjectLockConfiguration getObjectLockConfiguration(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.GET, bucketName, "object-lock");
        try {
            return this.executeRequest(this.client, request, ObjectLockConfiguration.class);
        }
        catch (S3Exception e) {
            if (e.getHttpCode() == 404 && "ObjectLockConfigurationNotFoundError".equals(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void enableObjectLock(String bucketName) {
        GenericBucketRequest request = new GenericBucketRequest(Method.PUT, bucketName, "enable-object-lock");
        this.executeAndClose(this.client, request);
    }

    @Override
    public void setObjectLegalHold(SetObjectLegalHoldRequest request) {
        this.executeAndClose(this.client, request);
    }

    @Override
    public ObjectLockLegalHold getObjectLegalHold(GetObjectLegalHoldRequest request) {
        try {
            return this.executeRequest(this.client, request, ObjectLockLegalHold.class);
        }
        catch (S3Exception e) {
            if (e.getHttpCode() == 404 && "NoSuchObjectLockConfiguration".equals(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void setObjectRetention(SetObjectRetentionRequest request) {
        this.executeAndClose(this.client, request);
    }

    @Override
    public ObjectLockRetention getObjectRetention(GetObjectRetentionRequest request) {
        try {
            return this.executeRequest(this.client, request, ObjectLockRetention.class);
        }
        catch (S3Exception e) {
            if (e.getHttpCode() == 404 && "NoSuchObjectLockConfiguration".equals(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    protected <T> T executeRequest(Client client, ObjectRequest request, Class<T> responseType) {
        ClientResponse response = this.executeRequest(client, request);
        try {
            Object responseEntity = response.getEntity(responseType);
            this.fillResponseEntity(responseEntity, response);
            return (T)responseEntity;
        }
        catch (ClientHandlerException e) {
            try {
                throw ErrorFilter.parseErrorResponse(new StringReader((String)response.getEntity(String.class)), response.getStatus());
            }
            catch (Throwable t) {
                throw e;
            }
        }
    }

    public S3Config getS3Config() {
        return this.s3Config;
    }
}

