/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object;

import com.emc.object.EntityRequest;
import com.emc.object.Method;
import com.emc.object.ObjectConfig;
import com.emc.object.ObjectRequest;
import com.emc.object.ObjectResponse;
import com.emc.object.s3.S3Exception;
import com.emc.object.util.RestUtil;
import com.emc.rest.smart.jersey.SizeOverrideWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJerseyClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractJerseyClient.class);
    protected ObjectConfig objectConfig;

    protected AbstractJerseyClient(ObjectConfig objectConfig) {
        this.objectConfig = objectConfig;
    }

    protected Response executeAndClose(JerseyClient client, ObjectRequest request) {
        Response response = this.executeRequest(client, request);
        response.close();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response executeRequest(JerseyClient client, ObjectRequest request) {
        String contentType = null;
        String contentEncoding = RestUtil.getFirstAsString(request.getHeaders(), "Content-Encoding");
        Object entity = null;
        Method method = request.getMethod();
        if (method.isRequiresEntity()) {
            contentType = "application/octet-stream";
            entity = new byte[]{};
            if (request instanceof EntityRequest) {
                EntityRequest entityRequest = (EntityRequest)((Object)request);
                if (entityRequest.getContentType() != null) {
                    contentType = entityRequest.getContentType();
                }
                if (entityRequest.getEntity() != null) {
                    entity = entityRequest.getEntity();
                }
                if (entityRequest.getContentLength() != null) {
                    log.debug("enabling content-length override ({})", (Object)entityRequest.getContentLength().toString());
                    SizeOverrideWriter.setEntitySize((Long)entityRequest.getContentLength());
                } else if (!entityRequest.isChunkable()) {
                    log.debug("no content-length and request is not chunkable, attempting to enable buffering");
                    request.property("jersey.config.client.request.entity.processing", RequestEntityProcessing.BUFFERED);
                    request.property("jersey.config.client.chunkedEncodingSize", null);
                }
            } else {
                request.property("jersey.config.client.request.entity.processing", RequestEntityProcessing.BUFFERED);
                String headerContentType = RestUtil.getFirstAsString(request.getHeaders(), "Content-Type");
                if (headerContentType != null) {
                    contentType = headerContentType;
                }
            }
        } else if (request instanceof EntityRequest) {
            throw new UnsupportedOperationException("an entity request is using a non-entity method (" + (Object)((Object)request.getMethod()) + ")");
        }
        JerseyInvocation.Builder builder = this.buildRequest(client, request);
        int retryCount = 0;
        InputStream entityStream = null;
        if (entity instanceof InputStream) {
            entityStream = (InputStream)entity;
        }
        while (true) {
            try {
                if (this.objectConfig.isRetryEnabled() && entityStream != null && entityStream.markSupported()) {
                    entityStream.mark(this.objectConfig.getRetryBufferSize());
                }
                Response response = Objects.isNull(entity) ? builder.method(method.name()) : builder.method(method.name(), Entity.entity((Object)entity, (Variant)new Variant(MediaType.valueOf((String)contentType), (String)null, contentEncoding)));
                return response;
            }
            catch (RuntimeException orig) {
                Boolean encode;
                Throwable t = orig;
                if (t instanceof ProcessingException) {
                    t = t.getCause();
                }
                if (t instanceof S3Exception) {
                    S3Exception se = (S3Exception)((Object)t);
                    if (se.getHttpCode() < 500 || se.getHttpCode() == 501) {
                        throw se;
                    }
                } else if (!(t instanceof IOException)) {
                    throw orig;
                }
                if ((encode = (Boolean)request.getProperties().get("com.emc.object.codec.encodeEntity")) != null && encode.booleanValue()) {
                    Map userMeta = (Map)request.getProperties().get("com.emc.object.userMetadata");
                    userMeta.clear();
                }
                if (!this.objectConfig.isRetryEnabled()) {
                    throw orig;
                }
                if (++retryCount > this.objectConfig.getRetryLimit()) {
                    throw orig;
                }
                if (entityStream != null) {
                    try {
                        entityStream.reset();
                    }
                    catch (IOException e) {
                        log.warn("could not reset entity stream for retry: " + e);
                        throw orig;
                    }
                }
                if (this.objectConfig.getInitialRetryDelay() <= 0) continue;
                int retryDelay = this.objectConfig.getInitialRetryDelay() * (int)Math.pow(2.0, retryCount - 1);
                try {
                    log.debug("waiting {}ms before retry", (Object)retryDelay);
                    Thread.sleep(retryDelay);
                }
                catch (InterruptedException e) {
                    log.warn("interrupted while waiting to retry: " + e.getMessage());
                }
                log.warn("error received in response [{}], retrying ({} of {})...", new Object[]{t, retryCount, this.objectConfig.getRetryLimit()});
                request.property("com.emc.object.retryCount", retryCount);
                continue;
            }
            finally {
                SizeOverrideWriter.setEntitySize(null);
                continue;
            }
            break;
        }
    }

    protected <T> T executeRequest(JerseyClient client, ObjectRequest request, Class<T> responseType) {
        Response response = this.executeRequest(client, request);
        Object responseEntity = response.readEntity(responseType);
        this.fillResponseEntity(responseEntity, response);
        response.close();
        return (T)responseEntity;
    }

    protected void fillResponseEntity(Object responseEntity, Response response) {
        if (responseEntity instanceof ObjectResponse) {
            ((ObjectResponse)responseEntity).setHeaders((Map<String, List<String>>)response.getStringHeaders());
        }
    }

    protected JerseyInvocation.Builder buildRequest(JerseyClient client, ObjectRequest request) {
        String namespace;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        URI uri = this.objectConfig.resolvePath(request.getPath(), request.getRawQueryString());
        JerseyWebTarget webTarget = client.target(uri);
        for (Map.Entry<String, Object> entry : request.getProperties().entrySet()) {
            webTarget.property(entry.getKey(), entry.getValue());
        }
        String string = namespace = request.getNamespace() != null ? request.getNamespace() : this.objectConfig.getNamespace();
        if (namespace != null) {
            webTarget.property("com.emc.object.namespace", (Object)namespace);
        }
        JerseyInvocation.Builder builder = webTarget.request();
        for (String name : request.getHeaders().keySet()) {
            for (Object value : request.getHeaders().get(name)) {
                builder = builder.header(name, value);
            }
        }
        return builder;
    }

    public ObjectConfig getObjectConfig() {
        return this.objectConfig;
    }
}

