/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.Range;
import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.bean.CompleteMultipartUploadResult;
import com.emc.object.s3.bean.ListPartsResult;
import com.emc.object.s3.bean.MultipartPart;
import com.emc.object.s3.bean.MultipartPartETag;
import com.emc.object.s3.bean.PutObjectResult;
import com.emc.object.s3.lfu.LargeFileMultipartFileSource;
import com.emc.object.s3.lfu.LargeFileMultipartSource;
import com.emc.object.s3.lfu.LargeFileUpload;
import com.emc.object.s3.lfu.LargeFileUploaderResumeContext;
import com.emc.object.s3.lfu.PartMismatchException;
import com.emc.object.s3.request.AbortMultipartUploadRequest;
import com.emc.object.s3.request.CompleteMultipartUploadRequest;
import com.emc.object.s3.request.InitiateMultipartUploadRequest;
import com.emc.object.s3.request.ListPartsRequest;
import com.emc.object.s3.request.PutObjectRequest;
import com.emc.object.s3.request.UploadPartRequest;
import com.emc.object.util.ProgressInputStream;
import com.emc.object.util.ProgressListener;
import com.emc.rest.util.SizedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeFileUploader
implements Runnable,
ProgressListener {
    private static final Logger log = LoggerFactory.getLogger(LargeFileUploader.class);
    public static final int DEFAULT_THREADS = 8;
    public static final int DEFAULT_MPU_THRESHOLD = 0x20000000;
    public static final long MIN_PART_SIZE = 0x400000L;
    public static final long DEFAULT_PART_SIZE = 0x8000000L;
    public static final int MAX_PARTS = 10000;
    private final S3Client s3Client;
    private final String bucket;
    private final String key;
    private final InputStream stream;
    private final LargeFileMultipartSource multipartSource;
    private long fullSize = -1L;
    private final AtomicLong bytesTransferred = new AtomicLong();
    private String eTag;
    private String versionId;
    private S3ObjectMetadata objectMetadata;
    private AccessControlList acl;
    private CannedAcl cannedAcl;
    private boolean closeStream = true;
    private long mpuThreshold = 0x20000000L;
    private Long partSize = 0x8000000L;
    private int threads = 8;
    private ExecutorService executorService;
    private boolean externalExecutorService;
    private ProgressListener progressListener;
    private final AtomicBoolean active = new AtomicBoolean(false);
    private LargeFileUploaderResumeContext resumeContext;
    private Map<Integer, MultipartPartETag> existingMpuParts = null;
    private boolean abortMpuOnFailure = true;

    public static String getMpuETag(List<MultipartPartETag> partETags) {
        String aggHexString = partETags.stream().map(MultipartPartETag::getETag).collect(Collectors.joining(""));
        byte[] rawBytes = DatatypeConverter.parseHexBinary((String)aggHexString);
        return DigestUtils.md5Hex((byte[])rawBytes) + "-" + partETags.size();
    }

    public LargeFileUploader(S3Client s3Client, String bucket, String key, File file) {
        this(s3Client, bucket, key, new LargeFileMultipartFileSource(file));
    }

    public LargeFileUploader(S3Client s3Client, String bucket, String key, InputStream stream, long size) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.key = key;
        this.stream = stream;
        this.fullSize = size;
        this.multipartSource = null;
    }

    public LargeFileUploader(S3Client s3Client, String bucket, String key, LargeFileMultipartSource multipartSource) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.key = key;
        this.multipartSource = multipartSource;
        this.stream = null;
    }

    @Override
    public void progress(long completed, long total) {
    }

    @Override
    public void transferred(long size) {
        long totalTransferred = this.bytesTransferred.addAndGet(size);
        if (this.progressListener != null) {
            this.progressListener.transferred(size);
            this.progressListener.progress(totalTransferred, this.fullSize);
        }
    }

    @Override
    public void run() {
        this.upload();
    }

    protected long getMinPartSize() {
        return 0x400000L;
    }

    protected String putObject(InputStream is) {
        PutObjectRequest putRequest = new PutObjectRequest(this.bucket, this.key, is);
        putRequest.setObjectMetadata(this.objectMetadata);
        putRequest.setAcl(this.acl);
        putRequest.setCannedAcl(this.cannedAcl);
        PutObjectResult result = this.s3Client.putObject(putRequest);
        return result.getETag();
    }

    protected List<MultipartPart> listParts(String uploadId) {
        ArrayList<MultipartPart> partList = new ArrayList<MultipartPart>();
        ListPartsRequest request = new ListPartsRequest(this.bucket, this.key, uploadId);
        ListPartsResult result = null;
        do {
            if (result != null) {
                request.setMarker(result.getNextPartNumberMarker());
            }
            result = this.s3Client.listParts(request);
            partList.addAll(result.getParts());
        } while (result.isTruncated());
        return partList;
    }

    protected String initMpu() {
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucket, this.key);
        initRequest.setObjectMetadata(this.objectMetadata);
        initRequest.setAcl(this.acl);
        initRequest.setCannedAcl(this.cannedAcl);
        return this.s3Client.initiateMultipartUpload(initRequest).getUploadId();
    }

    protected MultipartPartETag uploadPart(String uploadId, int partNumber, InputStream is, long length) {
        UploadPartRequest request = new UploadPartRequest(this.bucket, this.key, uploadId, partNumber, is);
        request.setContentLength(length);
        return this.s3Client.uploadPart(request);
    }

    protected CompleteMultipartUploadResult completeMpu(String uploadId, SortedSet<MultipartPartETag> parts) {
        CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.bucket, this.key, uploadId).withParts(parts);
        return this.s3Client.completeMultipartUpload(compRequest);
    }

    protected void abortMpu(String uploadId) {
        this.s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, this.key, uploadId));
    }

    public LargeFileUpload uploadAsync() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        final Future<?> future = executor.submit(this::upload);
        executor.shutdown();
        return new LargeFileUpload(){

            @Override
            public void waitForCompletion() {
                try {
                    future.get();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void waitForCompletion(long timeout, TimeUnit timeoutUnit) throws TimeoutException {
                try {
                    future.get(timeout, timeoutUnit);
                }
                catch (RuntimeException | TimeoutException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public LargeFileUploaderResumeContext pause() {
                LargeFileUploader.this.active.set(false);
                this.waitForCompletion();
                return LargeFileUploader.this.resumeContext;
            }

            @Override
            public void abort() {
                LargeFileUploader.this.active.set(false);
                if (LargeFileUploader.this.resumeContext != null && LargeFileUploader.this.resumeContext.getUploadId() != null) {
                    LargeFileUploader.this.abortMpu(LargeFileUploader.this.resumeContext.getUploadId());
                    LargeFileUploader.this.resumeContext.setUploadId(null);
                    LargeFileUploader.this.resumeContext.setUploadedParts(null);
                }
                LargeFileUploader.this.executorService.shutdownNow();
            }
        };
    }

    public void upload() {
        this.configure();
        if (this.fullSize >= this.mpuThreshold) {
            this.doMultipartUpload();
        } else {
            this.doSinglePut();
        }
    }

    private InputStream getSourceCompleteDataStream() throws IOException {
        InputStream is = this.multipartSource != null ? this.multipartSource.getCompleteDataStream() : new FilterInputStream(this.stream){

            @Override
            public void close() throws IOException {
                if (LargeFileUploader.this.closeStream) {
                    super.close();
                } else {
                    log.debug("leaving source stream open");
                }
            }
        };
        return is;
    }

    private InputStream getSourcePartDataStream(long offset, long length) throws IOException {
        InputStream is = this.multipartSource != null ? this.multipartSource.getPartDataStream(offset, length) : new FilterInputStream((InputStream)new SizedInputStream(this.stream, length)){

            @Override
            public void close() {
            }
        };
        return is;
    }

    protected InputStream monitorStream(InputStream stream) {
        return new ProgressInputStream(stream, this);
    }

    public void doSinglePut() {
        this.configure();
        try (InputStream is = this.monitorStream(this.getSourceCompleteDataStream());){
            this.eTag = this.putObject(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening file", e);
        }
    }

    private Map<Integer, MultipartPartETag> listUploadPartsForResume(String uploadId) {
        List<MultipartPart> existingParts = this.listParts(uploadId);
        HashMap<Integer, MultipartPartETag> partsForResume = new HashMap<Integer, MultipartPartETag>();
        if (existingParts != null) {
            existingParts.sort(Comparator.comparingInt(MultipartPartETag::getPartNumber));
            int lastPart = (int)((this.fullSize - 1L) / this.partSize) + 1;
            long lastPartSize = this.fullSize - (long)(lastPart - 1) * this.partSize;
            for (MultipartPart part : existingParts) {
                long expectedSize;
                if (part.getPartNumber() > lastPart) {
                    throw new IllegalArgumentException(String.format("Too many parts in uploadId: %s: last part is %d, but saw partNumber %d", uploadId, lastPart, part.getPartNumber()));
                }
                long l = expectedSize = part.getPartNumber() == lastPart ? lastPartSize : this.partSize;
                if (!part.getSize().equals(expectedSize)) {
                    throw new IllegalArgumentException(String.format("Invalid part size detected in uploadId: %s/%d: expected %d, but saw %d", uploadId, part.getPartNumber(), expectedSize, part.getSize()));
                }
                partsForResume.put(part.getPartNumber(), part);
            }
        }
        return partsForResume;
    }

    public void doMultipartUpload() {
        this.configure();
        this.active.set(true);
        if (this.resumeContext != null && this.resumeContext.getUploadId() != null && this.resumeContext.getUploadedParts() == null) {
            this.existingMpuParts = this.listUploadPartsForResume(this.resumeContext.getUploadId());
        }
        if (this.resumeContext == null) {
            this.resumeContext = new LargeFileUploaderResumeContext();
        }
        if (this.resumeContext.getUploadId() == null) {
            this.resumeContext.setUploadId(this.initMpu());
        }
        if (this.resumeContext.getUploadedParts() == null) {
            this.resumeContext.setUploadedParts(new HashMap<Integer, MultipartPartETag>());
        }
        ArrayList<Object> futures = new ArrayList<Object>();
        try {
            int lastPart = (int)((this.fullSize - 1L) / this.partSize) + 1;
            for (int partNumber = 1; partNumber <= lastPart; ++partNumber) {
                long length;
                long l = (long)(partNumber - 1) * this.partSize;
                if (l + (length = this.partSize.longValue()) > this.fullSize) {
                    length = this.fullSize - l;
                }
                if (this.resumeContext.getUploadedParts().containsKey(partNumber)) {
                    log.debug("bucket {} key {} partNumber {} provided in resume context; will use the provided ETag and this part will not be verified", new Object[]{this.bucket, this.key, partNumber});
                    continue;
                }
                if (this.existingMpuParts != null && this.existingMpuParts.containsKey(partNumber)) {
                    log.debug("bucket {} key {} partNumber {} already exists, will be reused for multipart upload", new Object[]{this.bucket, this.key, partNumber});
                    if (this.resumeContext.isVerifyPartsFoundInTarget()) {
                        futures.add(CompletableFuture.supplyAsync(new VerifySourcePartTask(partNumber, l, length, this.existingMpuParts.get(partNumber).getRawETag()), this.executorService).exceptionally(this.partMismatchHandler(this.resumeContext.getUploadId(), partNumber, l, length)));
                        continue;
                    }
                    log.debug("verifyPartsFoundInTarget is false; not verifying existing part data for partNumber {} (ETag: {})", (Object)partNumber, (Object)this.existingMpuParts.get(partNumber).getETag());
                    this.resumeContext.getUploadedParts().put(partNumber, new MultipartPartETag(partNumber, this.existingMpuParts.get(partNumber).getETag()));
                    continue;
                }
                futures.add(this.executorService.submit(new UploadPartTask(this.resumeContext.getUploadId(), partNumber, l, length)));
            }
            for (Future future : futures) {
                try {
                    this.resumeContext.getUploadedParts().put(((MultipartPartETag)future.get()).getPartNumber(), (MultipartPartETag)future.get());
                }
                catch (ExecutionException e) {
                    Throwable t;
                    for (t = e; t.getCause() != null && t.getCause() != t; t = t.getCause()) {
                    }
                    if (t instanceof CancellationException) continue;
                    throw e;
                }
            }
            if (this.active.get()) {
                CompleteMultipartUploadResult result = this.completeMpu(this.resumeContext.getUploadId(), new TreeSet<MultipartPartETag>(this.resumeContext.getUploadedParts().values()));
                this.eTag = result.getRawETag();
                this.versionId = result.getVersionId();
            }
        }
        catch (Exception e) {
            try {
                if (this.abortMpuOnFailure) {
                    this.abortMpu(this.resumeContext.getUploadId());
                    this.resumeContext.setUploadId(null);
                    this.resumeContext.setUploadedParts(null);
                }
            }
            catch (Throwable t) {
                log.warn("could not abort upload after failure", t);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("error during upload", e);
        }
        finally {
            this.active.set(false);
            if (!this.externalExecutorService) {
                this.executorService.shutdownNow();
            }
            if (this.stream != null && this.closeStream) {
                try {
                    this.stream.close();
                }
                catch (Throwable t) {
                    log.warn("could not close stream", t);
                }
            }
        }
    }

    private Function<Throwable, ? extends MultipartPartETag> partMismatchHandler(String uploadId, int partNumber, long offset, long length) {
        return throwable -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (this.resumeContext.isOverwriteMismatchedParts() && throwable instanceof PartMismatchException) {
                log.warn(throwable.getMessage());
                log.info("overwriting partNumber {} due to ETag mismatch", (Object)partNumber);
                return new UploadPartTask(uploadId, partNumber, offset, length).call();
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException((Throwable)throwable);
        };
    }

    public void doByteRangeUpload() {
        this.configure();
        PutObjectRequest request = new PutObjectRequest(this.bucket, this.key, null);
        request.setObjectMetadata(this.objectMetadata);
        request.setAcl(this.acl);
        request.setCannedAcl(this.cannedAcl);
        this.s3Client.putObject(request);
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        try {
            long length = this.partSize;
            for (long offset = 0L; offset < this.fullSize; offset += length) {
                if (offset + length > this.fullSize) {
                    length = this.fullSize - offset;
                }
                futures.add(this.executorService.submit(new PutObjectTask(offset, length)));
            }
            for (Future future : futures) {
                this.eTag = (String)future.get();
            }
        }
        catch (Exception e) {
            try {
                this.s3Client.deleteObject(this.bucket, this.key);
            }
            catch (Throwable t) {
                log.warn("could not delete object after failure", t);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("error during upload", e);
        }
        finally {
            if (!this.externalExecutorService) {
                this.executorService.shutdown();
            }
            if (this.stream != null && this.closeStream) {
                try {
                    this.stream.close();
                }
                catch (Throwable t) {
                    log.warn("could not close stream", t);
                }
            }
        }
    }

    protected void configure() {
        if (this.multipartSource != null) {
            this.fullSize = this.multipartSource.getTotalSize();
        } else if (this.stream != null) {
            if (this.fullSize < 0L) {
                throw new IllegalArgumentException("size must be specified for stream");
            }
            if (this.resumeContext != null) {
                this.resumeContext.setVerifyPartsFoundInTarget(true);
            }
            this.executorService = null;
            this.threads = 1;
        } else {
            throw new IllegalArgumentException("must specify a file, stream, or multipartSource to read");
        }
        if (this.objectMetadata != null) {
            this.objectMetadata.setContentLength(null);
        }
        long minPartSize = Math.max(this.getMinPartSize(), this.fullSize / 10000L + 1L);
        log.debug(String.format("minimum part size calculated as %,dk", minPartSize / 1024L));
        if (this.partSize == null) {
            this.partSize = minPartSize;
        }
        if (this.partSize < minPartSize) {
            log.warn(String.format("%,dk is below the minimum part size (%,dk). the minimum will be used instead", this.partSize / 1024L, minPartSize / 1024L));
            this.partSize = minPartSize;
        }
        if (this.resumeContext != null) {
            if (this.fullSize < this.mpuThreshold) {
                throw new UnsupportedOperationException("cannot resume MPU because the size of the source is below the MPU threshold");
            }
            if (this.resumeContext.getUploadId() == null) {
                throw new IllegalArgumentException("must provide an uploadId to resume");
            }
        }
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.threads);
        } else {
            this.externalExecutorService = true;
        }
    }

    public S3Client getS3Client() {
        return this.s3Client;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public LargeFileMultipartSource getMultipartSource() {
        return this.multipartSource;
    }

    public long getFullSize() {
        return this.fullSize;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred.get();
    }

    public String getETag() {
        return this.eTag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public S3ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAcl cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    public long getMpuThreshold() {
        return this.mpuThreshold;
    }

    public void setMpuThreshold(long mpuThreshold) {
        this.mpuThreshold = mpuThreshold;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public LargeFileUploaderResumeContext getResumeContext() {
        return this.resumeContext;
    }

    public void setResumeContext(LargeFileUploaderResumeContext resumeContext) {
        this.resumeContext = resumeContext;
    }

    public boolean isAbortMpuOnFailure() {
        return this.abortMpuOnFailure;
    }

    public void setAbortMpuOnFailure(boolean abortMpuOnFailure) {
        this.abortMpuOnFailure = abortMpuOnFailure;
    }

    public LargeFileUploader withObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public LargeFileUploader withAcl(AccessControlList acl) {
        this.setAcl(acl);
        return this;
    }

    public LargeFileUploader withCannedAcl(CannedAcl cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }

    public LargeFileUploader withCloseStream(boolean closeStream) {
        this.setCloseStream(closeStream);
        return this;
    }

    public LargeFileUploader withMpuThreshold(long mpuThreshold) {
        this.setMpuThreshold(mpuThreshold);
        return this;
    }

    public LargeFileUploader withPartSize(Long partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public LargeFileUploader withThreads(int threads) {
        this.setThreads(threads);
        return this;
    }

    public LargeFileUploader withExecutorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public LargeFileUploader withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public LargeFileUploader withResumeContext(LargeFileUploaderResumeContext resumeContext) {
        this.setResumeContext(resumeContext);
        return this;
    }

    public LargeFileUploader withAbortMpuOnFailure(boolean abortMpuOnFailure) {
        this.setAbortMpuOnFailure(abortMpuOnFailure);
        return this;
    }

    protected class VerifySourcePartTask
    implements Supplier<MultipartPartETag> {
        private final int partNumber;
        private final long offset;
        private final long length;
        private final String uploadedETag;

        public VerifySourcePartTask(int partNumber, long offset, long length, String uploadedETag) {
            this.partNumber = partNumber;
            this.offset = offset;
            this.length = length;
            this.uploadedETag = uploadedETag;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public MultipartPartETag get() {
            if (!LargeFileUploader.this.active.get()) {
                throw new CancellationException();
            }
            log.debug("reading existing partNumber {} (offset: {}, length: {}) from source to verify data", new Object[]{this.partNumber, this.offset, this.length});
            try (InputStream is = LargeFileUploader.this.getSourcePartDataStream(this.offset, this.length);){
                String sourceETag = DigestUtils.md5Hex((InputStream)is);
                if (!sourceETag.equals(this.uploadedETag)) {
                    throw new PartMismatchException(this.partNumber, sourceETag, this.uploadedETag);
                }
                MultipartPartETag multipartPartETag = new MultipartPartETag(this.partNumber, sourceETag);
                return multipartPartETag;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class PutObjectTask
    implements Callable<String> {
        private final long offset;
        private final long length;

        public PutObjectTask(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String call() {
            try (InputStream is = LargeFileUploader.this.monitorStream(LargeFileUploader.this.getSourcePartDataStream(this.offset, this.length));){
                Range range = Range.fromOffsetLength(this.offset, this.length);
                PutObjectRequest request = new PutObjectRequest(LargeFileUploader.this.bucket, LargeFileUploader.this.key, is).withRange(range);
                String string = LargeFileUploader.this.s3Client.putObject(request).getETag();
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class UploadPartTask
    implements Callable<MultipartPartETag> {
        private final String uploadId;
        private final int partNumber;
        private final long offset;
        private final long length;

        public UploadPartTask(String uploadId, int partNumber, long offset, long length) {
            this.uploadId = uploadId;
            this.partNumber = partNumber;
            this.offset = offset;
            this.length = length;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public MultipartPartETag call() {
            if (!LargeFileUploader.this.active.get()) {
                throw new CancellationException();
            }
            log.debug("uploading {}/{}, uploadId: {}, partNumber {} (offset: {}, length: {})", new Object[]{LargeFileUploader.this.bucket, LargeFileUploader.this.key, this.uploadId, this.partNumber, this.offset, this.length});
            try (InputStream is = LargeFileUploader.this.monitorStream(LargeFileUploader.this.getSourcePartDataStream(this.offset, this.length));){
                MultipartPartETag multipartPartETag = LargeFileUploader.this.uploadPart(this.uploadId, this.partNumber, is, this.length);
                return multipartPartETag;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

