/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.ObjectConfig;
import com.emc.object.Protocol;
import com.emc.object.util.ConfigUriProperty;
import com.emc.rest.smart.Host;
import com.emc.rest.smart.SmartConfig;
import com.emc.rest.smart.ecs.Vdc;
import java.net.URI;

public class S3Config
extends ObjectConfig<S3Config> {
    public static final int DEFAULT_HTTP_PORT = 9020;
    public static final int DEFAULT_HTTPS_PORT = 9021;
    protected boolean useVHost = false;
    protected boolean signNamespace = true;
    protected boolean checksumEnabled = true;
    protected float faultInjectionRate = 0.0f;
    protected boolean signMetadataSearch = true;
    protected boolean useV2Signer = true;

    protected static int defaultPort(Protocol protocol) {
        if (protocol == Protocol.HTTP) {
            return 9020;
        }
        if (protocol == Protocol.HTTPS) {
            return 9021;
        }
        throw new IllegalArgumentException("unknown protocol: " + (Object)((Object)protocol));
    }

    public S3Config() {
    }

    public S3Config(URI endpoint) {
        super(endpoint);
    }

    public S3Config(Protocol protocol, String ... hostList) {
        super(protocol, S3Config.defaultPort(protocol), hostList);
    }

    public S3Config(Protocol protocol, Vdc ... vdcs) {
        super(protocol, S3Config.defaultPort(protocol), vdcs);
    }

    public S3Config(S3Config other) {
        super(other);
        this.useVHost = other.useVHost;
        this.signNamespace = other.signNamespace;
        this.checksumEnabled = other.checksumEnabled;
        this.faultInjectionRate = other.faultInjectionRate;
        this.signMetadataSearch = other.signMetadataSearch;
        this.useV2Signer = other.useV2Signer;
    }

    @Override
    public Host resolveHost() {
        return (Host)this.getVdcs().get(0).getHosts().get(0);
    }

    @Override
    public SmartConfig toSmartConfig() {
        return super.toSmartConfig().withProperty("com.emc.rest.smart.disableApacheRetry", (Object)Boolean.TRUE);
    }

    @ConfigUriProperty
    public boolean isUseVHost() {
        return this.useVHost;
    }

    public void setUseVHost(boolean useVHost) {
        this.useVHost = useVHost;
    }

    @ConfigUriProperty
    public boolean isSignNamespace() {
        return this.signNamespace;
    }

    public void setSignNamespace(boolean signNamespace) {
        this.signNamespace = signNamespace;
    }

    @ConfigUriProperty
    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    public void setChecksumEnabled(boolean checksumEnabled) {
        this.checksumEnabled = checksumEnabled;
    }

    @ConfigUriProperty
    public float getFaultInjectionRate() {
        return this.faultInjectionRate;
    }

    public void setFaultInjectionRate(float faultInjectionRate) {
        this.faultInjectionRate = faultInjectionRate;
    }

    @ConfigUriProperty
    public boolean isSignMetadataSearch() {
        return this.signMetadataSearch;
    }

    public void setSignMetadataSearch(boolean signMetadataSearch) {
        this.signMetadataSearch = signMetadataSearch;
    }

    @ConfigUriProperty
    public boolean isUseV2Signer() {
        return this.useV2Signer;
    }

    public void setUseV2Signer(boolean useV2Signer) {
        this.useV2Signer = useV2Signer;
    }

    public S3Config withUseVHost(boolean useVHost) {
        this.setUseVHost(useVHost);
        return this;
    }

    public S3Config withSignNamespace(boolean signNamespace) {
        this.setSignNamespace(signNamespace);
        return this;
    }

    public S3Config withChecksumEnabled(boolean checksumEnabled) {
        this.setChecksumEnabled(checksumEnabled);
        return this;
    }

    public S3Config withFaultInjectionRate(float faultInjectionRate) {
        this.setFaultInjectionRate(faultInjectionRate);
        return this;
    }

    public S3Config withSignMetadataSearch(boolean signMetadataSearch) {
        this.setSignMetadataSearch(signMetadataSearch);
        return this;
    }

    public S3Config withUseV2Signer(boolean useV2Signer) {
        this.setUseV2Signer(useV2Signer);
        return this;
    }

    @Override
    public String toString() {
        return "S3Config{useVHost=" + this.useVHost + ", signNamespace=" + this.signNamespace + ", checksumEnabled=" + this.checksumEnabled + ", retryEnabled=" + this.retryEnabled + ", initialRetryDelay=" + this.initialRetryDelay + ", retryLimit=" + this.retryLimit + ", retryBufferSize=" + this.retryBufferSize + ", faultInjectionRate=" + this.faultInjectionRate + ", signMetadataSearch=" + this.signMetadataSearch + ", useV2Signer=" + this.useV2Signer + "} " + super.toString();
    }
}

