/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.rest.smart.SmartClientException;

public class S3Exception
extends SmartClientException {
    private final int httpCode;
    private String errorCode;
    private String requestId;

    public S3Exception(String message, int httpCode) {
        super(message);
        this.httpCode = httpCode;
        this.setErrorType(this.fromHttpCode(httpCode));
    }

    public S3Exception(String message, int httpCode, Throwable cause) {
        super(message, cause);
        this.httpCode = httpCode;
        this.setErrorType(this.fromHttpCode(httpCode));
    }

    public S3Exception(String message, int httpCode, String errorCode, String requestId) {
        super(message);
        this.httpCode = httpCode;
        this.errorCode = errorCode;
        this.requestId = requestId;
        this.setErrorType(this.fromHttpCode(httpCode));
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    private SmartClientException.ErrorType fromHttpCode(int httpCode) {
        return httpCode >= 400 && httpCode < 500 ? SmartClientException.ErrorType.Client : (httpCode >= 500 && httpCode < 600 ? SmartClientException.ErrorType.Service : SmartClientException.ErrorType.Unknown);
    }
}

