/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Signer;
import com.emc.object.s3.jersey.BucketFilter;
import com.emc.object.s3.jersey.NamespaceFilter;
import com.emc.object.s3.request.PresignedUrlRequest;
import com.emc.object.s3.request.ResponseHeaderOverride;
import com.emc.object.util.RestUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.client.ClientRequestContext;

public class S3SignerV4
extends S3Signer {
    private static final String HEADER_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String AMZ_DATE_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String AMZ_DATE_FORMAT_SHORT = "yyyyMMdd";
    private static final long PRESIGN_URL_MAX_EXPIRATION_SECONDS = 604800L;
    private static final String HASHED_EMPTY_PAYLOAD = S3SignerV4.hexEncode(S3SignerV4.hash256(""));
    private static final SortedSet<String> excludedSignedHeaders = new TreeSet<String>(Arrays.asList("authorization"));

    public S3SignerV4(S3Config s3Config) {
        super(s3Config);
    }

    @Override
    public void sign(ClientRequestContext request, String resource, Map<String, String> parameters, Map<String, List<Object>> headers) {
        String serviceType = this.getServiceType();
        String date = this.getDate(parameters, headers);
        String shortDate = this.getShortDate(date);
        this.addHeadersForV4(request.getUri(), date, headers);
        String canonicalRequest = this.getCanonicalRequest(request.getMethod(), request.getUri(), parameters, headers, false);
        String stringToSign = this.getStringToSign(request.getMethod(), resource, parameters, headers, date, serviceType, canonicalRequest);
        log.debug("StringToSign: {}", (Object)stringToSign);
        SortedMap<String, String> canonicalizedHeaders = this.getCanonicalizedHeaders(headers, parameters);
        StringBuilder signedHeaders = new StringBuilder();
        for (String name : canonicalizedHeaders.keySet()) {
            if (signedHeaders.length() != 0) {
                signedHeaders.append(";");
            }
            signedHeaders.append(name);
        }
        byte[] key = this.getSigningKey(shortDate, serviceType);
        String signature = this.getSignature(stringToSign, key);
        log.debug("Signature: {}", (Object)signature);
        RestUtil.putSingle(headers, "Authorization", "AWS4-HMAC-SHA256 Credential=" + this.s3Config.getIdentity() + "/" + shortDate + "/" + "us-east-1" + "/" + serviceType + "/" + "aws4_request" + ", SignedHeaders=" + signedHeaders + ", " + "Signature" + "=" + signature);
    }

    protected void addHeadersForV4(URI uri, String date, Map<String, List<Object>> headers) {
        StringBuilder hostHeader = new StringBuilder(uri.getHost());
        if (!(this.s3Config.getProtocol().equals("https") && uri.getPort() == 443 || this.s3Config.getProtocol().equals("http") && uri.getPort() == 80 || uri.getPort() == -1)) {
            hostHeader.append(":").append(uri.getPort());
        }
        if (!headers.containsKey("x-amz-date")) {
            RestUtil.putSingle(headers, "x-amz-date", date);
        }
        RestUtil.putSingle(headers, "Host", hostHeader);
    }

    protected String getCanonicalRequest(String method, URI uri, Map<String, String> parameters, Map<String, List<Object>> headers, Boolean isForPresignedUrl) {
        StringBuilder canonicalRequest = new StringBuilder();
        canonicalRequest.append(method).append("\n");
        if (uri != null) {
            String uriString = uri.toString().replaceAll("%2F", "/");
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid URI syntax", e);
            }
        }
        String resource = RestUtil.getEncodedPath(uri);
        canonicalRequest.append(resource).append("\n");
        canonicalRequest.append(this.getCanonicalizedQueryString(parameters));
        SortedMap<String, String> canonicalizedHeaders = this.getCanonicalizedHeaders(headers, parameters);
        StringBuilder signedHeaders = new StringBuilder();
        for (String name : canonicalizedHeaders.keySet()) {
            canonicalRequest.append(name).append(":").append(((String)canonicalizedHeaders.get(name)).trim());
            canonicalRequest.append("\n");
            if (signedHeaders.length() != 0) {
                signedHeaders.append(";");
            }
            signedHeaders.append(name);
        }
        canonicalRequest.append("\n");
        signedHeaders.append("\n");
        canonicalRequest.append((CharSequence)signedHeaders);
        if (isForPresignedUrl.booleanValue()) {
            canonicalRequest.append("UNSIGNED-PAYLOAD");
        } else {
            canonicalRequest.append(HASHED_EMPTY_PAYLOAD);
        }
        log.debug("CanonicalRequest: {}", (Object)canonicalRequest);
        return canonicalRequest.toString();
    }

    private String getCanonicalizedQueryString(Map<String, String> parameters) {
        StringBuilder queryString = new StringBuilder();
        if (parameters != null & parameters.size() != 0) {
            TreeMap<String, String> sortedParameters = new TreeMap<String, String>();
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                sortedParameters.put(parameter.getKey(), RestUtil.urlEncode(parameter.getValue()));
            }
            StringBuilder sortedQueryString = new StringBuilder();
            for (Map.Entry parameter : sortedParameters.entrySet()) {
                if (sortedQueryString != null && sortedQueryString.length() != 0) {
                    sortedQueryString.append("&");
                }
                sortedQueryString.append((String)parameter.getKey()).append("=");
                if (parameter.getValue() == null) continue;
                sortedQueryString.append((String)parameter.getValue());
            }
            queryString.append((CharSequence)sortedQueryString).append("\n");
        } else {
            queryString.append("\n");
        }
        return queryString.toString();
    }

    @Override
    protected SortedMap<String, String> getCanonicalizedHeaders(Map<String, List<Object>> headers, Map<String, String> parameters) {
        TreeMap<String, String> canonicalizedHeaders = new TreeMap<String, String>();
        for (String header : headers.keySet()) {
            String lcHeader = header.toLowerCase();
            if (excludedSignedHeaders.contains(lcHeader)) continue;
            canonicalizedHeaders.put(lcHeader, this.trimAndJoin(headers.get(header), ","));
        }
        return canonicalizedHeaders;
    }

    protected String getStringToSign(String method, String resource, Map<String, String> parameters, Map<String, List<Object>> headers, String date, String service, String canonicalRequest) {
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append("AWS4-HMAC-SHA256").append("\n");
        stringToSign.append(date).append("\n");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(AMZ_DATE_FORMAT).withLocale(Locale.US);
        try {
            LocalDateTime dateTime = LocalDateTime.parse(date, formatter);
            date = DateTimeFormatter.ofPattern(AMZ_DATE_FORMAT_SHORT).withLocale(Locale.US).format(dateTime);
        }
        catch (DateTimeException e) {
            throw new RuntimeException("invalid date header: " + date, e);
        }
        stringToSign.append(this.getScope(date, service)).append("\n");
        byte[] hash = S3SignerV4.hash256(canonicalRequest);
        String hashedRequest = S3SignerV4.hexEncode(hash);
        stringToSign.append(hashedRequest);
        return stringToSign.toString();
    }

    protected byte[] getSigningKey(String date, String service) {
        return this.hmac("HmacSHA256", this.hmac("HmacSHA256", this.hmac("HmacSHA256", this.hmac("HmacSHA256", ("AWS4" + this.s3Config.getSecretKey()).getBytes(StandardCharsets.UTF_8), date), "us-east-1"), service), "aws4_request");
    }

    @Override
    protected String getDate(Map<String, String> parameters, Map<String, List<Object>> headers) {
        String date = null;
        if (headers.containsKey("x-amz-date")) {
            date = RestUtil.getFirstAsString(headers, "x-amz-date");
            return date;
        }
        date = RestUtil.getFirstAsString(headers, "Date");
        if (date == null) {
            date = RestUtil.getRequestDate(this.s3Config.getServerClockSkew());
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(HEADER_DATE_FORMAT).withLocale(Locale.US);
        try {
            LocalDateTime dateTime = LocalDateTime.parse(date, formatter);
            return DateTimeFormatter.ofPattern(AMZ_DATE_FORMAT).withLocale(Locale.US).format(dateTime);
        }
        catch (DateTimeException e) {
            throw new RuntimeException("invalid date header: " + date, e);
        }
    }

    protected String getShortDate(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(AMZ_DATE_FORMAT).withLocale(Locale.US);
        try {
            LocalDateTime dateTime = LocalDateTime.parse(date, formatter);
            return DateTimeFormatter.ofPattern(AMZ_DATE_FORMAT_SHORT).withLocale(Locale.US).format(dateTime);
        }
        catch (DateTimeException e) {
            throw new RuntimeException("invalid date: " + date, e);
        }
    }

    protected String getScope(String shortDate, String service) {
        return shortDate + "/" + "us-east-1" + "/" + service + "/" + "aws4_request";
    }

    @Override
    protected String getSignature(String stringToSign, byte[] signingKey) {
        try {
            return S3SignerV4.hexEncode(this.hmac("HmacSHA256", signingKey, stringToSign));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get getSignature");
        }
    }

    protected String getServiceType() {
        return "s3";
    }

    @Override
    public URL generatePresignedUrl(PresignedUrlRequest request) {
        String namespace = request.getNamespace() != null ? request.getNamespace() : this.s3Config.getNamespace();
        URI uri = this.s3Config.resolvePath(request.getPath(), null);
        String resource = "/" + request.getBucketName() + RestUtil.getEncodedPath(uri);
        if (namespace != null) {
            if (this.s3Config.isUseVHost()) {
                uri = NamespaceFilter.insertNamespace(uri, namespace);
                if (this.s3Config.isSignNamespace()) {
                    resource = "/" + namespace + resource;
                }
            } else {
                log.warn("vHost namespace is disabled, so there is no way to specify a namespace in a pre-signed URL");
            }
        }
        uri = BucketFilter.insertBucket(uri, request.getBucketName(), this.s3Config.isUseVHost());
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        if (request.getVersionId() != null) {
            parameters.put("versionId", request.getVersionId());
        }
        Map<ResponseHeaderOverride, String> headerOverrides = request.getHeaderOverrides();
        for (ResponseHeaderOverride override : headerOverrides.keySet()) {
            parameters.put(override.getQueryParam(), headerOverrides.get((Object)override));
        }
        Map<String, List<Object>> headers = request.getHeaders();
        String method = request.getMethod().name();
        String date = null;
        String serviceType = this.getServiceType();
        date = headers.containsKey("x-amz-date") ? RestUtil.getFirstAsString(headers, "x-amz-date") : this.getDate(parameters, headers);
        String shortDate = this.getShortDate(date);
        SortedMap<String, String> canonicalizedHeaders = this.getCanonicalizedHeaders(headers, parameters);
        StringBuilder signedHeaders = new StringBuilder();
        for (String string : canonicalizedHeaders.keySet()) {
            if (signedHeaders.length() != 0) {
                signedHeaders.append(";");
            }
            signedHeaders.append(string);
        }
        TreeMap<String, String> sortedParameters = new TreeMap<String, String>();
        for (Map.Entry entry : parameters.entrySet()) {
            sortedParameters.put((String)entry.getKey(), (String)entry.getValue());
        }
        sortedParameters.put("Action", method);
        sortedParameters.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        sortedParameters.put("X-Amz-Credential", RestUtil.urlDecode(this.s3Config.getIdentity() + "/" + shortDate + "/" + "us-east-1" + "/" + serviceType + "/" + "aws4_request"));
        sortedParameters.put("X-Amz-Date", date);
        sortedParameters.put("X-Amz-Expires", Long.toString(this.generateExpiration(request.getExpirationTime())));
        sortedParameters.put("X-Amz-SignedHeaders", RestUtil.urlDecode(signedHeaders.toString()));
        String string = this.getCanonicalRequest(method, uri, sortedParameters, headers, true);
        log.debug("CanonicalRequest: {}", (Object)string);
        String string2 = this.getStringToSign(method, resource, parameters, headers, date, serviceType, string);
        log.debug("StringToSign: {}", (Object)string2);
        byte[] key = this.getSigningKey(shortDate, serviceType);
        String signature = this.getSignature(string2, key);
        log.debug("Signature: {}", (Object)signature);
        sortedParameters.put("X-Amz-Signature", signature);
        String rawQueryString = RestUtil.generateRawQueryString(sortedParameters);
        URI newUri = null;
        try {
            newUri = RestUtil.buildUri(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), rawQueryString, uri.getRawFragment());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        try {
            return new URL(newUri.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("generated URL is not well-formed");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generated URL. ");
        }
    }

    private long generateExpiration(Date expirationDate) {
        long expirationInSeconds;
        long l = expirationInSeconds = expirationDate != null ? (expirationDate.getTime() - System.currentTimeMillis()) / 1000L : 604800L;
        if (expirationInSeconds > 604800L) {
            throw new IllegalArgumentException("A presigned URL can be valid for a maximum of seven days. The expiration date " + expirationInSeconds + " set on the current request has exceeded this limit.");
        }
        return expirationInSeconds;
    }
}

