/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.bean;

import com.emc.object.s3.bean.CommonPrefix;
import com.emc.object.s3.bean.EncodingType;
import com.emc.object.s3.bean.S3Object;
import com.emc.object.s3.bean.UrlEncodable;
import com.emc.object.util.RestUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="ListBucketResult")
public class ListObjectsResult
implements UrlEncodable {
    private String bucketName;
    private String prefix;
    private String delimiter;
    private Integer maxKeys;
    private EncodingType encodingType;
    private String marker;
    private String nextMarker;
    private boolean truncated;
    private List<S3Object> objects = new ArrayList<S3Object>();
    private List<CommonPrefix> _commonPrefixes = new ArrayList<CommonPrefix>();

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.encodingType == EncodingType.url) {
            this.bucketName = RestUtil.urlDecode(this.bucketName, false);
            this.prefix = RestUtil.urlDecode(this.prefix, false);
            this.delimiter = RestUtil.urlDecode(this.delimiter, false);
            this.marker = RestUtil.urlDecode(this.marker, false);
            this.nextMarker = RestUtil.urlDecode(this.nextMarker, false);
            for (S3Object object : this.objects) {
                object._afterUnmarshal(unmarshaller, this);
            }
            for (CommonPrefix prefix : this._commonPrefixes) {
                prefix._afterUnmarshal(unmarshaller, this);
            }
        }
    }

    @XmlElement(name="Name")
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @XmlElement(name="Prefix")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @XmlElement(name="Delimiter")
    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @XmlElement(name="MaxKeys")
    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    @Override
    @XmlElement(name="EncodingType")
    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(EncodingType encodingType) {
        this.encodingType = encodingType;
    }

    @XmlElement(name="Marker")
    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    @XmlElement(name="NextMarker")
    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    @XmlElement(name="IsTruncated")
    public boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(boolean truncated) {
        this.truncated = truncated;
    }

    @XmlElement(name="Contents")
    public List<S3Object> getObjects() {
        return this.objects;
    }

    public void setObjects(List<S3Object> objects) {
        this.objects = objects;
    }

    @XmlElement(name="CommonPrefixes")
    protected List<CommonPrefix> get_commonPrefixes() {
        return this._commonPrefixes;
    }

    protected void set_commonPrefixes(List<CommonPrefix> _commonPrefixes) {
        this._commonPrefixes = _commonPrefixes;
    }

    @XmlTransient
    public List<String> getCommonPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (CommonPrefix prefix : this._commonPrefixes) {
            prefixes.add(prefix.getPrefix());
        }
        return prefixes;
    }
}

