/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Signer;
import com.emc.object.s3.S3SignerV2;
import com.emc.object.s3.S3SignerV4;
import com.emc.object.s3.VHostUtil;
import com.emc.object.util.RestUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=2000)
public class AuthorizationFilter
implements ClientRequestFilter {
    private S3Config s3Config;
    private S3Signer signer;

    public AuthorizationFilter(S3Config s3Config) {
        this.s3Config = s3Config;
        this.signer = s3Config.isUseV2Signer() ? new S3SignerV2(s3Config) : new S3SignerV4(s3Config);
    }

    public void filter(ClientRequestContext request) throws IOException {
        if (this.s3Config.getUserAgent() != null) {
            request.getHeaders().putSingle((Object)"User-Agent", (Object)this.s3Config.getUserAgent());
        }
        if (this.s3Config.getIdentity() != null) {
            Map<String, String> parameters = RestUtil.getQueryParameterMap(request.getUri().getRawQuery());
            Configuration configuration = request.getConfiguration();
            String resource = VHostUtil.getResourceString(this.s3Config, (String)configuration.getProperty("com.emc.object.namespace"), (String)configuration.getProperty("com.emc.object.s3.bucketName"), RestUtil.getEncodedPath(request.getUri()));
            this.signer.sign(request, resource, parameters, (Map<String, List<Object>>)request.getHeaders());
        }
    }
}

