/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.util.RestUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1100)
public class BucketFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(BucketFilter.class);
    private S3Config s3Config;

    public static URI insertBucket(URI uri, String bucketName, boolean useVHost) {
        try {
            if (useVHost) {
                String hostname = bucketName + "." + uri.getHost();
                uri = RestUtil.replaceHost(uri, hostname);
            } else {
                String resource = "/" + bucketName;
                if (!uri.getPath().isEmpty() && !"/".equals(uri.getPath())) {
                    resource = resource + uri.getPath();
                }
                uri = RestUtil.replacePath(uri, resource);
            }
            log.debug("URI including bucket: " + uri);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("bucket name \"%s\" generated an invalid URI", bucketName), e);
        }
    }

    public BucketFilter(S3Config s3Config) {
        this.s3Config = s3Config;
    }

    public void filter(ClientRequestContext request) throws IOException {
        URI uri = request.getUri();
        String bucketName = (String)request.getConfiguration().getProperty("com.emc.object.s3.bucketName");
        if (bucketName != null) {
            request.setUri(BucketFilter.insertBucket(uri, bucketName, this.s3Config.isUseVHost()));
        }
    }
}

