/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3Signer;
import com.emc.object.s3.S3SignerV2;
import com.emc.object.s3.S3SignerV4;
import com.emc.object.s3.VHostUtil;
import com.emc.object.util.ChecksumAlgorithm;
import com.emc.object.util.ChecksumValue;
import com.emc.object.util.RestUtil;
import com.emc.object.util.RunningChecksum;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;

@Provider
@Priority(value=1600)
public class ChecksumRequestFilter
implements ClientRequestFilter {
    private S3Config s3Config;
    private S3Signer signer;
    private ClientRequestContext clientRequestContext;
    private OutputStream buffer;

    public ChecksumRequestFilter(S3Config s3Config) {
        this.s3Config = s3Config;
        this.signer = s3Config.isUseV2Signer() ? new S3SignerV2(s3Config) : new S3SignerV4(s3Config);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        OutputStream out;
        Boolean verifyWrite = (Boolean)requestContext.getConfiguration().getProperty("com.emc.object.verifyWriteChecksum");
        Boolean generateMd5 = (Boolean)requestContext.getConfiguration().getProperty("com.emc.object.generateContentMd5");
        this.buffer = out = requestContext.getEntityStream();
        if (verifyWrite != null && verifyWrite.booleanValue() || generateMd5 != null && generateMd5.booleanValue()) {
            try {
                RunningChecksum checksum = new RunningChecksum(ChecksumAlgorithm.MD5);
                out = new ChecksummedOutputStream(out, checksum, generateMd5);
                requestContext.setEntityStream(out);
                this.clientRequestContext = requestContext;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("fatal: MD5 algorithm not found");
            }
        }
    }

    private class ChecksummedOutputStream
    extends OutputStream {
        private OutputStream delegate;
        private RunningChecksum checksum;
        private Boolean generateContentMd5;

        public ChecksummedOutputStream(OutputStream delegate, ChecksumAlgorithm algorithm, Boolean generateContentMd5) throws NoSuchAlgorithmException {
            this(delegate, new RunningChecksum(algorithm), generateContentMd5);
        }

        public ChecksummedOutputStream(OutputStream delegate, RunningChecksum checksum, Boolean generateContentMd5) {
            this.delegate = delegate;
            this.checksum = checksum;
            this.generateContentMd5 = generateContentMd5;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            this.update(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            if (this.generateContentMd5 != null && this.generateContentMd5.booleanValue()) {
                ChecksumRequestFilter.this.clientRequestContext.getHeaders().add((Object)"Content-MD5", (Object)DatatypeConverter.printBase64Binary((byte[])this.checksum.getByteValue()));
                if (ChecksumRequestFilter.this.s3Config.getIdentity() != null) {
                    Map<String, String> parameters = RestUtil.getQueryParameterMap(ChecksumRequestFilter.this.clientRequestContext.getUri().getRawQuery());
                    String resource = VHostUtil.getResourceString(ChecksumRequestFilter.this.s3Config, (String)ChecksumRequestFilter.this.clientRequestContext.getProperty("com.emc.object.namespace"), (String)ChecksumRequestFilter.this.clientRequestContext.getProperty("com.emc.object.s3.bucketName"), RestUtil.getEncodedPath(ChecksumRequestFilter.this.clientRequestContext.getUri()));
                    ChecksumRequestFilter.this.signer.sign(ChecksumRequestFilter.this.clientRequestContext, resource, parameters, (Map<String, List<Object>>)ChecksumRequestFilter.this.clientRequestContext.getHeaders());
                }
            } else {
                ChecksumRequestFilter.this.clientRequestContext.setProperty("com.emc.object.verifyWriteChecksumValue", (Object)this.checksum.getHexValue());
            }
            ChecksumRequestFilter.this.clientRequestContext.setEntityStream(ChecksumRequestFilter.this.buffer);
        }

        public ChecksumValue getChecksum() {
            return this.checksum;
        }

        private void update(byte[] bytes, int offset, int length) {
            this.checksum.update(bytes, offset, length);
        }
    }
}

