/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.util.ChecksumAlgorithm;
import com.emc.object.util.ChecksumError;
import com.emc.object.util.ChecksumValueImpl;
import com.emc.object.util.ChecksummedInputStream;
import com.emc.object.util.RestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=4500)
public class ChecksumResponseFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        String checksumHexValue;
        Boolean verifyWrite;
        String contentMd5;
        String md5Header = RestUtil.getFirstAsString(responseContext.getHeaders(), "ETag");
        if (md5Header != null) {
            md5Header = md5Header.replaceAll("\"", "");
        }
        if (md5Header != null && (md5Header.length() <= 2 || md5Header.contains("-"))) {
            md5Header = null;
        }
        if ((contentMd5 = RestUtil.getFirstAsString(responseContext.getHeaders(), "x-emc-content-md5")) != null) {
            md5Header = contentMd5;
        }
        if ((verifyWrite = (Boolean)requestContext.getConfiguration().getProperty("com.emc.object.verifyWriteChecksum")) != null && verifyWrite.booleanValue() && md5Header != null && !(checksumHexValue = (String)requestContext.getProperty("com.emc.object.verifyWriteChecksumValue")).equals(md5Header)) {
            throw new ChecksumError("Checksum failure while writing stream", checksumHexValue, md5Header);
        }
        Boolean verifyRead = (Boolean)requestContext.getConfiguration().getProperty("com.emc.object.verifyReadChecksum");
        if (verifyRead != null && verifyRead.booleanValue() && md5Header != null) {
            try {
                responseContext.setEntityStream((InputStream)new ChecksummedInputStream(responseContext.getEntityStream(), new ChecksumValueImpl(ChecksumAlgorithm.MD5, 0L, md5Header)));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("fatal: MD5 algorithm not found");
            }
        }
    }
}

