/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.codec.CodecChain;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.rest.smart.jersey.SizeOverrideWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1800)
public class CodecRequestFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CodecRequestFilter.class);
    private final CodecChain encodeChain;
    private Map<String, Object> codecProperties;

    public CodecRequestFilter(CodecChain encodeChain) {
        this.encodeChain = encodeChain;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        Map userMeta = (Map)requestContext.getConfiguration().getProperty("com.emc.object.userMetadata");
        Boolean encode = (Boolean)requestContext.getConfiguration().getProperty("com.emc.object.codec.encodeEntity");
        if (encode != null && encode.booleanValue()) {
            Long originalSize = SizeOverrideWriter.getEntitySize();
            if (this.encodeChain.isSizePredictable() && originalSize != null) {
                long encodedSize = this.encodeChain.getEncodedSize(originalSize.longValue());
                log.debug("updating content-length for encoded data (original: {}, encoded: {})", (Object)originalSize, (Object)encodedSize);
                SizeOverrideWriter.setEntitySize((Long)encodedSize);
            } else {
                SizeOverrideWriter.setEntitySize((Long)-1L);
            }
            requestContext.setProperty("com.emc.object.meta.backup", new HashMap(userMeta));
            OutputStream encodeStream = this.encodeChain.getEncodeStream(requestContext.getEntityStream(), userMeta);
            requestContext.setProperty("com.emc.object.userMetadata", new HashMap(userMeta));
            requestContext.getHeaders().putAll(S3ObjectMetadata.getUmdHeaders(userMeta));
            requestContext.setEntityStream(encodeStream);
        }
    }

    public Map<String, Object> getCodecProperties() {
        return this.codecProperties;
    }

    public void setCodecProperties(Map<String, Object> codecProperties) {
        this.codecProperties = codecProperties;
    }

    public CodecRequestFilter withCodecProperties(Map<String, Object> codecProperties) {
        this.setCodecProperties(codecProperties);
        return this;
    }
}

