/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.codec.CodecChain;
import com.emc.object.s3.S3ObjectMetadata;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=4000)
public class CodecResponseFilter
implements ClientResponseFilter {
    private Map<String, Object> codecProperties;

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        MultivaluedMap headers = responseContext.getHeaders();
        Map<String, String> storedMeta = S3ObjectMetadata.getUserMetadata(headers);
        HashSet<String> keysToRemove = new HashSet<String>(storedMeta.keySet());
        String[] encodeSpecs = CodecChain.getEncodeSpecs(storedMeta);
        if (encodeSpecs != null) {
            CodecChain decodeChain = new CodecChain(encodeSpecs).withProperties(this.codecProperties);
            Boolean decode = (Boolean)requestContext.getConfiguration().getProperty("com.emc.object.codec.decodeEntity");
            if (decode != null && decode.booleanValue()) {
                responseContext.setEntityStream(decodeChain.getDecodeStream(responseContext.getEntityStream(), storedMeta));
            } else {
                decodeChain.removeEncodeMetadata(storedMeta, decodeChain.getEncodeMetadataList(storedMeta));
            }
            Boolean keepHeaders = (Boolean)requestContext.getConfiguration().getProperty("com.emc.object.codec.keepEncodeHeaders");
            if (keepHeaders == null || !keepHeaders.booleanValue()) {
                keysToRemove.removeAll(storedMeta.keySet());
                for (String key : keysToRemove) {
                    headers.remove((Object)S3ObjectMetadata.getHeaderName(key));
                }
            }
        }
    }

    public Map<String, Object> getCodecProperties() {
        return this.codecProperties;
    }

    public void setCodecProperties(Map<String, Object> codecProperties) {
        this.codecProperties = codecProperties;
    }

    public CodecResponseFilter withCodecProperties(Map<String, Object> codecProperties) {
        this.setCodecProperties(codecProperties);
        return this;
    }
}

