/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Exception;
import com.emc.object.util.RestUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3600)
public class ErrorFilter
implements ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorFilter.class);

    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        if (response.getStatus() > 299) {
            if (response.getStatus() == 403) {
                long skew;
                Date clientTime = RestUtil.amzHeaderParse(RestUtil.getFirstAsString(request.getHeaders(), "x-amz-date"));
                if (clientTime == null) {
                    clientTime = RestUtil.headerParse(RestUtil.getFirstAsString(request.getHeaders(), "Date"));
                }
                Date serverTime = RestUtil.headerParse(RestUtil.getFirstAsString(response.getHeaders(), "Date"));
                if (clientTime != null && serverTime != null && Math.abs(skew = clientTime.getTime() - serverTime.getTime()) > 300000L) {
                    log.warn("clock skew detected! client is more than 5 minutes off from server (" + skew + "ms)");
                }
            }
            if (response.hasEntity()) {
                throw ErrorFilter.parseErrorResponse(new InputStreamReader(response.getEntityStream()), response.getStatus());
            }
            try {
                response.getEntityStream().close();
            }
            catch (Throwable t) {
                log.warn("could not close response after error", t);
            }
            Response.StatusType st = response.getStatusInfo();
            throw new S3Exception(st.getReasonPhrase(), st.getStatusCode(), this.guessStatus(st.getStatusCode()), (String)response.getHeaders().getFirst((Object)"x-amz-request-id"));
        }
    }

    private String guessStatus(int statusCode) {
        switch (statusCode) {
            case 400: {
                return "InvalidArgument";
            }
            case 403: {
                return "AccessDenied";
            }
            case 404: {
                return "NoSuchKey";
            }
            case 405: {
                return "MethodNotAllowed";
            }
            case 500: {
                return "InternalError";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static S3Exception parseErrorResponse(Reader reader, int statusCode) {
        Document d;
        SAXReader saxReader = new SAXReader();
        try {
            d = saxReader.read(reader);
        }
        catch (Throwable t) {
            S3Exception s3Exception = new S3Exception("could not parse error response", statusCode, t);
            return s3Exception;
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable t) {
                log.warn("could not close reader", t);
            }
        }
        String code = d.getRootElement().elementText("Code");
        String message = d.getRootElement().elementText("Message");
        String requestId = d.getRootElement().elementText("RequestId");
        if (code == null && message == null) {
            return new S3Exception("no code or message in error response", statusCode);
        }
        log.debug("Error: {}, message: {}, requestId: {}", new Object[]{code, message, requestId});
        return new S3Exception(message, statusCode, code, requestId);
    }
}

