/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Exception;
import java.util.Random;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=2400)
public class FaultInjectionFilter
implements ClientRequestFilter {
    public static final String FAULT_INJECTION_ERROR_CODE = "FaultInjection";
    public static final String FAULT_INJECTION_ERROR_MESSAGE = "Fault Injection";
    public static final float DEFAULT_FAILURE_RATE = 0.25f;
    private Random random = new Random();
    private float failureRate;

    public FaultInjectionFilter() {
        this(0.25f);
    }

    public FaultInjectionFilter(float failureRate) {
        this.failureRate = failureRate;
    }

    public void filter(ClientRequestContext requestContext) throws WebApplicationException {
        if (this.random.nextFloat() < this.failureRate) {
            throw new S3Exception(FAULT_INJECTION_ERROR_MESSAGE, 500, FAULT_INJECTION_ERROR_CODE, null);
        }
    }

    public float getFailureRate() {
        return this.failureRate;
    }
}

