/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.Method;
import com.emc.object.ObjectConfig;
import com.emc.object.util.GeoPinningUtil;
import com.emc.rest.smart.ecs.Vdc;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1200)
public class GeoPinningFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(GeoPinningFilter.class);
    private final ObjectConfig<?> objectConfig;

    public GeoPinningFilter(ObjectConfig<?> objectConfig) {
        this.objectConfig = objectConfig;
    }

    public void filter(ClientRequestContext request) throws IOException {
        Configuration configuration = request.getConfiguration();
        String bucketName = (String)configuration.getProperty("com.emc.object.s3.bucketName");
        String objectKey = (String)configuration.getProperty("com.emc.object.s3.objectKey");
        if (bucketName != null) {
            Integer retries;
            ArrayList<Vdc> healthyVdcs = new ArrayList<Vdc>();
            for (Vdc vdc : this.objectConfig.getVdcs()) {
                if (!vdc.isHealthy()) continue;
                healthyVdcs.add(vdc);
            }
            if (healthyVdcs.isEmpty()) {
                log.debug("there are no healthy VDCs; geo-pinning will include all VDCs");
                healthyVdcs.addAll(this.objectConfig.getVdcs());
            }
            int geoPinIndex = GeoPinningUtil.getGeoPinIndex(GeoPinningUtil.getGeoId(bucketName, objectKey), healthyVdcs.size());
            if (this.objectConfig.isGeoReadRetryFailover() && Method.GET.name().equalsIgnoreCase(request.getMethod()) && (retries = (Integer)configuration.getProperty("com.emc.object.retryCount")) != null) {
                int newIndex = (geoPinIndex + retries) % healthyVdcs.size();
                log.info("geo-pin read retry #{}: failing over from primary VDC {} to VDC {}", new Object[]{retries, geoPinIndex, newIndex});
                geoPinIndex = newIndex;
            }
            request.setProperty("com.emc.object.geoPinnedVdc", healthyVdcs.get(geoPinIndex));
        }
    }

    public ObjectConfig<?> getObjectConfig() {
        return this.objectConfig;
    }
}

