/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.util.RestUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class NamespaceFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(NamespaceFilter.class);
    private S3Config s3Config;

    public static URI insertNamespace(URI uri, String namespace) {
        try {
            String hostname = namespace + "." + uri.getHost();
            log.debug("hostname including namespace: {}", (Object)hostname);
            return RestUtil.replaceHost(uri, hostname);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("namespace \"%s\" generated an invalid URI", namespace), e);
        }
    }

    public NamespaceFilter(S3Config s3Config) {
        this.s3Config = s3Config;
    }

    public void filter(ClientRequestContext request) throws IOException {
        String namespace = (String)request.getConfiguration().getProperty("com.emc.object.namespace");
        if (namespace != null) {
            if (this.s3Config.isUseVHost()) {
                request.setUri(NamespaceFilter.insertNamespace(request.getUri(), namespace));
            } else {
                request.getHeaders().putSingle((Object)"x-emc-namespace", (Object)namespace);
            }
        }
    }
}

