/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.EntityRequest;
import com.emc.object.Method;
import com.emc.object.s3.bean.CopyRange;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.List;
import java.util.Map;

public class CopyRangeRequest
extends S3ObjectRequest
implements EntityRequest {
    private String contentMd5;
    private String copyMode;
    private String multiPartCopy;
    private CopyRange copyRange;

    public CopyRangeRequest(String bucketName, String key) {
        super(Method.PUT, bucketName, key, null);
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.contentMd5 != null) {
            RestUtil.putSingle(headers, "Content-MD5", this.contentMd5);
        }
        if (this.copyMode != null) {
            RestUtil.putSingle(headers, "x-emc-copy-mode", this.copyMode);
        }
        if (this.multiPartCopy != null) {
            RestUtil.putSingle(headers, "x-emc-multipart-copy", this.multiPartCopy);
        }
        return headers;
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public Long getContentLength() {
        return null;
    }

    @Override
    public boolean isChunkable() {
        return false;
    }

    @Override
    public Object getEntity() {
        return this.copyRange;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public String getCopyMode() {
        return this.copyMode;
    }

    public void setCopyMode(String copyMode) {
        this.copyMode = copyMode;
    }

    public String getMultiPartCopy() {
        return this.multiPartCopy;
    }

    public void setMultiPartCopy(String multiPartCopy) {
        this.multiPartCopy = multiPartCopy;
    }

    public CopyRange getCopyRange() {
        return this.copyRange;
    }

    public void setCopyRange(CopyRange copyRange) {
        this.copyRange = copyRange;
    }

    public CopyRangeRequest withContentMd5(String contentMd5) {
        this.setContentMd5(contentMd5);
        return this;
    }

    public CopyRangeRequest withCopyMode(String copyMode) {
        this.setCopyMode(copyMode);
        return this;
    }

    public CopyRangeRequest withMultiPartCopy(String multiPartCopy) {
        this.setMultiPartCopy(multiPartCopy);
        return this;
    }

    public CopyRangeRequest withCopyRange(CopyRange copyRange) {
        this.setCopyRange(copyRange);
        return this;
    }
}

