/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.EntityRequest;
import com.emc.object.Method;
import com.emc.object.s3.bean.ObjectLockRetention;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.List;
import java.util.Map;

public class SetObjectRetentionRequest
extends S3ObjectRequest
implements EntityRequest {
    private ObjectLockRetention retention;
    private Boolean bypassGovernanceRetention;
    private String versionId;

    public SetObjectRetentionRequest(String bucketName, String key) {
        super(Method.PUT, bucketName, key, "retention");
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        if (this.versionId != null) {
            queryParams.put("versionId", this.versionId);
        }
        return queryParams;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.bypassGovernanceRetention != null) {
            RestUtil.putSingle(headers, "x-amz-bypass-governance-retention", this.bypassGovernanceRetention.toString());
        }
        return headers;
    }

    @Override
    public Long getContentLength() {
        return null;
    }

    @Override
    public boolean isChunkable() {
        return false;
    }

    @Override
    public Object getEntity() {
        return this.retention;
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    public ObjectLockRetention getRetention() {
        return this.retention;
    }

    public SetObjectRetentionRequest withRetention(ObjectLockRetention retention) {
        this.setRetention(retention);
        return this;
    }

    public void setRetention(ObjectLockRetention retention) {
        this.retention = retention;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public SetObjectRetentionRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public boolean getBypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    public SetObjectRetentionRequest withBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
        this.setBypassGovernanceRetention(bypassGovernanceRetention);
        return this;
    }

    public void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
        this.bypassGovernanceRetention = bypassGovernanceRetention;
    }
}

