/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.encryption;

import com.emc.codec.EncodeMetadata;
import com.emc.codec.encryption.EncryptionException;
import com.emc.codec.encryption.EncryptionUtil;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.xml.bind.DatatypeConverter;

public class EncryptionMetadata
extends EncodeMetadata {
    private long originalSize;
    private byte[] originalDigest;
    private String masterKeyFingerprint;
    private String encryptedKey;
    private byte[] initVector;
    private String signature;

    public EncryptionMetadata(String encodeSpec) {
        super(encodeSpec);
    }

    public EncryptionMetadata(String encodeSpec, Map<String, String> metaMap) {
        this(encodeSpec);
        this.initVector = EncryptionUtil.urlSafeDecodeBase64(metaMap.get("x-emc-enc-iv"));
        if (this.initVector == null) {
            throw new EncryptionException("no initialization vector set on object.");
        }
        this.masterKeyFingerprint = metaMap.get("x-emc-enc-key-id");
        if (this.masterKeyFingerprint == null) {
            throw new EncryptionException("no master key ID set on object.");
        }
        this.encryptedKey = metaMap.get("x-emc-enc-object-key");
        if (this.encryptedKey == null) {
            throw new EncryptionException("no encryption key set on object.");
        }
        String originalDigestStr = metaMap.get("x-emc-enc-unencrypted-sha1");
        if (originalDigestStr == null) {
            throw new EncryptionException("no SHA1 digest set on object.");
        }
        this.originalDigest = DatatypeConverter.parseHexBinary((String)originalDigestStr);
        String originalSizeStr = metaMap.get("x-emc-enc-unencrypted-size");
        if (originalSizeStr == null) {
            throw new EncryptionException("no original size set on object.");
        }
        this.originalSize = Long.parseLong(originalSizeStr);
        this.signature = metaMap.get("x-emc-enc-metadata-signature");
        if (this.signature == null) {
            throw new EncryptionException("no signature set on object.");
        }
    }

    @Override
    public boolean isComplete() {
        return this.originalDigest != null && this.masterKeyFingerprint != null && this.encryptedKey != null && this.initVector != null && this.signature != null;
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> metaMap = new HashMap<String, String>();
        metaMap.put("x-emc-enc-iv", EncryptionUtil.urlSafeEncodeBase64(this.initVector));
        metaMap.put("x-emc-enc-object-key", this.encryptedKey);
        if (this.isComplete()) {
            metaMap.put("x-emc-enc-unencrypted-sha1", DatatypeConverter.printHexBinary((byte[])this.originalDigest).toLowerCase());
            metaMap.put("x-emc-enc-unencrypted-size", "" + this.originalSize);
            metaMap.put("x-emc-enc-key-id", this.masterKeyFingerprint);
            metaMap.put("x-emc-enc-metadata-signature", this.signature);
        }
        return metaMap;
    }

    public SecretKey getSecretKey(RSAPrivateKey privateKey, Provider provider) {
        String cipherSpec = EncryptionUtil.getCipherSpec(this.getEncodeSpec());
        return EncryptionUtil.decryptKey(this.encryptedKey, EncryptionUtil.getBaseAlgorithm(cipherSpec), provider, privateKey);
    }

    public void setSecretKey(SecretKey key, PublicKey publicKey, Provider provider) {
        this.encryptedKey = EncryptionUtil.encryptKey(key, provider, publicKey);
    }

    public void sign(RSAPrivateKey privateKey, Provider provider) {
        this.signature = this.generateSignature(privateKey, provider);
    }

    public void verifySignature(RSAPrivateKey privateKey, Provider provider) {
        String generated = this.generateSignature(privateKey, provider);
        if (!this.signature.equals(generated)) {
            throw new EncryptionException(String.format("signature does not match (assigned=%s, generated=%s)", this.signature, generated));
        }
    }

    protected String generateSignature(RSAPrivateKey privateKey, Provider provider) {
        Map<String, String> metaMap = this.toMap();
        metaMap.remove("x-emc-enc-metadata-signature");
        return EncryptionUtil.signMetadata(metaMap, privateKey, provider);
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
    }

    public byte[] getOriginalDigest() {
        return this.originalDigest;
    }

    public void setOriginalDigest(byte[] originalDigest) {
        this.originalDigest = originalDigest;
    }

    public String getMasterKeyFingerprint() {
        return this.masterKeyFingerprint;
    }

    public void setMasterKeyFingerprint(String masterKeyFingerprint) {
        this.masterKeyFingerprint = masterKeyFingerprint;
    }

    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    public void setEncryptedKey(String encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public byte[] getInitVector() {
        return this.initVector;
    }

    public void setInitVector(byte[] initVector) {
        this.initVector = initVector;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

