/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.encryption;

import com.emc.codec.util.CodecUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtil {
    private static final Logger log = LoggerFactory.getLogger(EncryptionUtil.class);

    public static String getRsaPublicKeyFingerprint(RSAPublicKey pubKey) {
        return DigestUtils.sha1Hex((byte[])EncryptionUtil.derEncodeRSAPublicKey(pubKey));
    }

    public static String toHexPadded(byte[] data) {
        BigInteger bi = new BigInteger(1, data);
        String s = bi.toString(16);
        while (s.length() < data.length * 2) {
            s = "0" + s;
        }
        return s;
    }

    public static byte[] derEncodeBigInteger(BigInteger value) {
        return EncryptionUtil.derEncodeValue((byte)2, value.toByteArray());
    }

    public static byte[] derEncodeValue(byte type, byte[] bytes) {
        if (bytes.length < 128) {
            byte[] der = new byte[bytes.length + 2];
            der[0] = type;
            der[1] = (byte)bytes.length;
            System.arraycopy(bytes, 0, der, 2, bytes.length);
            return der;
        }
        BigInteger bigLength = BigInteger.valueOf(bytes.length);
        byte[] lengthBytes = bigLength.toByteArray();
        byte[] der = new byte[bytes.length + lengthBytes.length + 2];
        der[0] = type;
        der[1] = (byte)(lengthBytes.length | 0x80);
        System.arraycopy(lengthBytes, 0, der, 2, lengthBytes.length);
        System.arraycopy(bytes, 0, der, 2 + lengthBytes.length, bytes.length);
        return der;
    }

    public static byte[] derEncodeRSAPublicKey(RSAPublicKey pubkey) {
        ArrayList<byte[]> sequence = new ArrayList<byte[]>();
        sequence.add(EncryptionUtil.derEncodeBigInteger(pubkey.getModulus()));
        sequence.add(EncryptionUtil.derEncodeBigInteger(pubkey.getPublicExponent()));
        return EncryptionUtil.derEncodeSequence(sequence);
    }

    public static byte[] derEncodeSequence(List<byte[]> objects) {
        int totalSize = 0;
        for (byte[] obj : objects) {
            totalSize += obj.length;
        }
        byte[] objectData = new byte[totalSize];
        int p = 0;
        for (byte[] obj : objects) {
            System.arraycopy(obj, 0, objectData, p, obj.length);
            p += obj.length;
        }
        return EncryptionUtil.derEncodeValue((byte)48, objectData);
    }

    public static KeyPair rsaKeyPairFromBase64(String publicKey, String privateKey) throws GeneralSecurityException {
        try {
            byte[] pubKeyBytes = Base64.decodeBase64((byte[])publicKey.getBytes("US-ASCII"));
            byte[] privKeyBytes = Base64.decodeBase64((byte[])privateKey.getBytes("US-ASCII"));
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
            return new KeyPair(pubKey, privKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not load key pair: " + e, e);
        }
    }

    public static SecretKey decryptKey(String encodedKey, String algorithm, Provider provider, PrivateKey privateKey) {
        try {
            Cipher cipher = provider != null ? Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", provider) : Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(2, privateKey);
            byte[] keyData = EncryptionUtil.urlSafeDecodeBase64(encodedKey);
            byte[] decryptedKey = cipher.doFinal(keyData);
            return new SecretKeySpec(decryptedKey, algorithm);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("error decrypting object key: " + e, e);
        }
    }

    public static String encryptKey(SecretKey key, Provider provider, PublicKey publicKey) {
        try {
            Cipher cipher = provider != null ? Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", provider) : Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, publicKey);
            byte[] encryptedKey = cipher.doFinal(key.getEncoded());
            return EncryptionUtil.urlSafeEncodeBase64(encryptedKey);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("error encrypting object key: " + e, e);
        }
    }

    public static String urlSafeEncodeBase64(byte[] data) {
        String b64Data;
        try {
            b64Data = new String(Base64.encodeBase64((byte[])data), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding not supported", e);
        }
        b64Data = b64Data.replace('+', '-');
        b64Data = b64Data.replace('/', '_');
        return b64Data;
    }

    public static byte[] urlSafeDecodeBase64(String b64Data) {
        byte[] data;
        b64Data = b64Data.replace('-', '+');
        b64Data = b64Data.replace('_', '/');
        try {
            data = Base64.decodeBase64((byte[])b64Data.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding not supported", e);
        }
        return data;
    }

    public static String signMetadata(Map<String, String> metadata, RSAPrivateKey privateKey, Provider provider) {
        Signature sig;
        byte[] byArray;
        ArrayList<String> keys = new ArrayList<String>();
        for (String string : metadata.keySet()) {
            if (!string.startsWith("x-emc-enc-")) continue;
            keys.add(string);
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 == null) {
                    return -s2.toLowerCase().compareTo(s1);
                }
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
        });
        StringBuffer canonicalString = new StringBuffer();
        for (String key : keys) {
            canonicalString.append(key.toLowerCase()).append(":").append(metadata.get(key)).append("\n");
        }
        log.debug("Canonical string: ''{}''", (Object)canonicalString);
        try {
            byArray = canonicalString.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not render string to bytes");
        }
        try {
            sig = provider != null ? Signature.getInstance("SHA256withRSA", provider) : Signature.getInstance("SHA256withRSA");
            sig.initSign(privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not initialize signature algorithm: " + e, e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize signature algorithm: " + e, e);
        }
        try {
            sig.update(byArray);
            byte[] signature = sig.sign();
            return EncryptionUtil.urlSafeEncodeBase64(signature);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Could not compute metadata signature: " + e);
        }
    }

    public static byte[] extractSubjectKeyIdentifier(byte[] derSki) {
        byte[] dst = new byte[20];
        if (derSki.length != 24) {
            throw new RuntimeException("DER-encoded SKI should be 24 bytes");
        }
        System.arraycopy(derSki, 4, dst, 0, 20);
        return dst;
    }

    public static String getCipherSpec(String encodeSpec) {
        return CodecUtil.getEncodeAlgorithm(encodeSpec);
    }

    public static String getBaseAlgorithm(String cipherSpec) {
        return cipherSpec.split("/")[0];
    }
}

