/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart;

import com.emc.rest.smart.Host;
import com.emc.rest.smart.SmartConfig;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;

public class SmartFilter
extends ClientFilter {
    public static final String BYPASS_LOAD_BALANCER = "com.emc.rest.smart.bypassLoadBalancer";
    private SmartConfig smartConfig;

    public SmartFilter(SmartConfig smartConfig) {
        this.smartConfig = smartConfig;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        Boolean bypass = (Boolean)request.getProperties().get(BYPASS_LOAD_BALANCER);
        if (bypass != null && bypass.booleanValue()) {
            return this.getNext().handle(request);
        }
        Host host = this.smartConfig.getLoadBalancer().getTopHost(request.getProperties());
        URI uri = request.getURI();
        try {
            HttpHost httpHost = new HttpHost(host.getName(), uri.getPort(), uri.getScheme());
            uri = URIUtils.rewriteURI((URI)uri, (HttpHost)httpHost);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("load-balanced host generated invalid URI", e);
        }
        request.setURI(uri);
        host.connectionOpened();
        try {
            ClientResponse response = this.getNext().handle(request);
            if (response.getStatus() >= 500 && response.getStatus() != 501) {
                host.callComplete(true);
            } else {
                host.callComplete(false);
            }
            response.setEntityInputStream((InputStream)new WrappedInputStream(response.getEntityInputStream(), host));
            return response;
        }
        catch (RuntimeException e) {
            host.callComplete(true);
            host.connectionClosed();
            throw e;
        }
    }

    protected class WrappedInputStream
    extends FilterInputStream {
        private Host host;
        private boolean closed;

        public WrappedInputStream(InputStream in, Host host) {
            super(in);
            this.closed = false;
            this.host = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            WrappedInputStream wrappedInputStream = this;
            synchronized (wrappedInputStream) {
                if (!this.closed) {
                    this.host.connectionClosed();
                    this.closed = true;
                }
            }
            super.close();
        }
    }
}

