/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api;

import com.emc.atmos.AbstractConfig;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;

public class AtmosConfig
extends AbstractConfig {
    public static final String DEFAULT_CONTEXT = "/rest";
    private String tokenId;
    private byte[] secretKey;
    private long serverClockSkew;
    private boolean enableRetry = true;
    private int retryDelayMillis = 0;
    private int maxRetries = 2;
    private int retryBufferSize = 0x100000;
    private boolean enableExpect100Continue = true;
    private URI proxyUri;
    private String proxyUser;
    private String proxyPassword;

    public AtmosConfig() {
        super(DEFAULT_CONTEXT, new URI[0]);
    }

    public AtmosConfig(String tokenId, String secretKey, URI ... endpoints) {
        super(DEFAULT_CONTEXT, endpoints);
        this.setSecretKey(secretKey);
        this.tokenId = tokenId;
    }

    public boolean isEnableExpect100Continue() {
        return this.enableExpect100Continue;
    }

    public void setEnableExpect100Continue(boolean enableExpect100Continue) {
        this.enableExpect100Continue = enableExpect100Continue;
    }

    public boolean isEnableRetry() {
        return this.enableRetry;
    }

    public void setEnableRetry(boolean enableRetry) {
        this.enableRetry = enableRetry;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getRetryBufferSize() {
        return this.retryBufferSize;
    }

    public void setRetryBufferSize(int retryBufferSize) {
        this.retryBufferSize = retryBufferSize;
    }

    public int getRetryDelayMillis() {
        return this.retryDelayMillis;
    }

    public void setRetryDelayMillis(int retryDelayMillis) {
        this.retryDelayMillis = retryDelayMillis;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }

    public void setSecretKey(String secretKey) {
        try {
            this.secretKey = Base64.decodeBase64((byte[])secretKey.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public long getServerClockSkew() {
        return this.serverClockSkew;
    }

    public void setServerClockSkew(long serverClockSkew) {
        this.serverClockSkew = serverClockSkew;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public URI getProxyUri() {
        return this.proxyUri;
    }

    public void setProxyUri(URI proxyUri) {
        this.proxyUri = proxyUri;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }
}

